% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/feat.R
\name{write.wig.feat}
\alias{write.wig.feat}
\title{Write a features object in fixedStep wig format}
\usage{
write.wig.feat(x, file = NULL, append = FALSE)
}
\arguments{
\item{x}{An object of type feat}

\item{file}{The name of the file to write to.  A value of NULL
implies write to console.}

\item{append}{If TRUE, append to the file.  Otherwise overwrite.}
}
\description{
Write a features object in fixedStep wig format
}
\note{
Wig format only contains chromosome, coordinates, and score.  Any
other data will be lost.

This function will quit with an error if the elements of x are
not all the same length (as required by fixedStep wig format).

If x is stored as a pointer to a C structure, the elements
will be sorted by this function.
}
\examples{
f <- feat(seqname=c("chr1", "chr1", "chr1", "chr1", "chr2"),
          start=c(1, 11, 21, 100, 1),
          end=c(3, 13, 23, 102, 3),
          score=runif(5))
write.wig.feat(f)
}
\author{
Melissa J. Hubisz
}
\keyword{GFF}
\keyword{features}
\keyword{fixedStep}
\keyword{wig}

