% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_phylopic.r
\name{add_phylopic}
\alias{add_phylopic}
\title{Input an image and create a ggplot2 layer to add to an existing plot}
\usage{
add_phylopic(img, alpha = 0.2, x = NULL, y = NULL, ysize = NULL,
  color = NULL)
}
\arguments{
\item{img}{A png object, e.g, from using \code{\link[=image_data]{image_data()}}}

\item{alpha}{A value between 0 and 1, specifying the opacity of the
silhouette.}

\item{x}{x value of the silhouette center. Ignored if y and ysize are not
specified.}

\item{y}{y value of the silhouette center. Ignored if x and ysize are not
specified.}

\item{ysize}{Height of the silhouette. The width is determined by the aspect
ratio of the original image. Ignored if x and y are not specified.}

\item{color}{Color to plot the silhouette in.}
}
\description{
Input an image and create a ggplot2 layer to add to an existing plot
}
\details{
Use parameters \code{x}, \code{y}, and \code{ysize} to place the silhouette at a
specified position on the plot. If all three of these parameters are
unspecified, then the silhouette will be plotted to the full height and width
of the plot.
}
\examples{
\dontrun{
# Put a silhouette behind a plot
library(ggplot2)
img <- image_data("27356f15-3cf8-47e8-ab41-71c6260b2724", size = "512")[[1]]
qplot(x=Sepal.Length, y=Sepal.Width, data=iris, geom="point") + 
  add_phylopic(img)

# Put a silhouette anywhere
library(ggplot2)
posx <- runif(50, 0, 10)
posy <- runif(50, 0, 10)
sizey <- runif(50, 0.4, 2)
cols <- sample(c("black", "darkorange", "grey42", "white"), 50, 
  replace = TRUE)

cat <- image_data("23cd6aa4-9587-4a2e-8e26-de42885004c9", size = 128)[[1]]
(p <- ggplot(data.frame(cat.x = posx, cat.y = posy), aes(cat.x, cat.y)) + 
 geom_point(color = rgb(0,0,0,0)))
for (i in 1:50) {
  p <- p + add_phylopic(cat, 1, posx[i], posy[i], sizey[i], cols[i])
}
p + ggtitle("R Cat Herd!!")
}
}
