% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfun_rpm_0_1.R
\name{in_node}
\alias{in_node}
\alias{rpms::in_node}
\title{in_node}
\usage{
in_node(node, t1, data)
}
\arguments{
\item{node}{integer label of the desired end-node.}

\item{t1}{\code{rpms} object}

\item{data}{dataframe containing the variables used for the recursive 
partitioning.}
}
\value{
vector of indexes for observations in the end-node.
}
\description{
Get index of elements in dataframe that are in the specified 
              end-node of an \code{rpms} object
}
\examples{
# model linear fit between retirement contributions and amount of income 
r1 <-rpms(FINDRETX~EDUC_REF+AGE_REF+BLS_URBN+REGION, data=CE,
     e_equ=FINDRETX~FINCBTAX, clusters=~CID) 

if(2 \%in\% end_nodes(r1))
  summary(CE$FSALARYX[in_node(node=2, r1, data=CE)])

if(6 \%in\% end_nodes(r1))
  summary(CE$FSALARYX[in_node(node=6, r1, data=CE)])

}
