% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgtraj2ltraj.R
\name{pgtraj2ltraj}
\alias{pgtraj2ltraj}
\alias{readTraj}
\title{Import a pgtraj into an ltraj.}
\usage{
pgtraj2ltraj(conn, pgtraj, schema = "traj")
}
\arguments{
\item{conn}{Connection object created with RPostgreSQL}

\item{pgtraj}{String. Name of the pgtraj}

\item{schema}{String. Name of the schema storing the pgtraj}
}
\value{
an ltraj object
}
\description{
\code{pgtraj2ltraj} imports a single pgtraj from a database into an
ltraj object.
}
\examples{
\dontrun{
 # create ltraj from pgtraj named "ibex" in schema "traj_t2"
 ibex<-pgtraj2ltraj(conn, "ibex", "traj_t2")
}
}
\author{
Balázs Dukai \email{balazs.dukai@gmail.com}
}
