% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frames.R
\name{FrameList}
\alias{FrameList}
\title{Convert lines from an Eprime file into EprimeFrame objects}
\usage{
FrameList(x)
}
\arguments{
\item{x}{a character vector with lines of the form \code{"key: value"}, or a
list of vectors of colon-separated text}
}
\value{
When passed a list of character vectors of \code{"key: value"} lines,
  a FrameList object (a list of EprimeFrames) is returned. when passed a
  single vector vector of \code{"key: value"} lines, a single EprimeFrame
  object is returned inside of a FrameList object.
}
\description{
Convert character vectors of implicit key-value pairs (e.g., \code{c("key1:
value1", "key2: value2")}), into  lists of explicit key-value pairs,
\code{list(key1 = "value1", key2 = "value2")}.
}
\details{
During the conversion, if \code{Running: x}, then the
  \code{x.Sample} and \code{x.Cycle} lines are simplified into \code{Sample}
  and \code{Cycle} lines. The \code{x: value} line is recoded as
  \code{Eprime.LevelName: x_value}. The purpose of this tidying is to force
  the same set of key names (eventually, column names) onto frames with
  different values for "Running".
}
\examples{
lines <- c("\t*** LogFrame Start ***",
           "\tProcedure: FamTask",
           "\titem1: bear",
           "\titem2: chair",
           "\tCorrectResponse: bear",
           "\tImageSide: Left",
           "\tDuration: 885",
           "\tFamiliarization: 1",
           "\tFamInforcer: 1",
           "\tReinforcerImage: Bicycle1",
           "\tFamiliarization.Cycle: 1",
           "\tFamiliarization.Sample: 1",
           "\tRunning: Familiarization",
           "\tFamTarget.RESP: ",
           "\tCorrect: True",
           "\t*** LogFrame End ***")
# List of 1
# $ :List of 17
# ..$ Eprime.Level      : num 2
# ..$ Eprime.LevelName  : chr "Familiarization_1"
# ..$ Eprime.Basename   : chr "NA"
# ..$ Eprime.FrameNumber: chr "1"
# ..$ Procedure         : chr "FamTask"
# ..$ Running           : chr "Familiarization"
# ..$ item1             : chr "bear"
# ..$ item2             : chr "chair"
# ..$ CorrectResponse   : chr "bear"
# ..$ ImageSide         : chr "Left"
# ..$ Duration          : chr "885"
# ..$ FamInforcer       : chr "1"
# ..$ ReinforcerImage   : chr "Bicycle1"
# ..$ Cycle             : chr "1"
# ..$ Sample            : chr "1"
# ..$ FamTarget.RESP    : chr ""
# ..$ Correct           : chr "True"
# ..- attr(*, "class")= chr [1:2] "EprimeFrame" "list"
# - attr(*, "class")= chr [1:2] "list" "FrameList"
}
