% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{gap_text}
\alias{gap_text}
\title{Create YAML string for TextGap object}
\usage{
gap_text(
  solution,
  tolerance = NULL,
  case_sensitive = FALSE,
  points = 1,
  response_identifier = NULL,
  expected_length = size_gap(solution),
  placeholder = NULL
)
}
\arguments{
\item{solution}{A character vector containing values considered as correct
answers.}

\item{tolerance}{An integer value, optional; defines the number of characters
to tolerate spelling mistakes in evaluating candidate answers.}

\item{case_sensitive}{A boolean, optional; determines whether the evaluation
of the correct answer is case sensitive. Default is \code{FALSE}.}

\item{points}{A numeric value, optional; the number of points for this gap.
Default is 1.}

\item{response_identifier}{A character string (optional) representing an
identifier for the answer.}

\item{expected_length}{An integer value, optional; sets the size of the text
input field in the content delivery engine.}

\item{placeholder}{A character string, optional; places helpful text in the
text input field in the content delivery engine.}
}
\value{
A character string mapped as yaml.
}
\description{
Create YAML string for TextGap object
}
\examples{
gap_text(c("Solution", "Solutions"), tolerance = 2)

}
\seealso{
\code{\link[=gap_numeric]{gap_numeric()}}, \code{\link[=dropdown]{dropdown()}}, \code{\link[=mdlist]{mdlist()}}
}
