% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project.R
\name{project_nse}
\alias{project_nse}
\title{project data by grouping, and adding aggregate columns.}
\usage{
project_nse(source, groupby, ..., env = parent.frame())
}
\arguments{
\item{source}{source to select from.}

\item{groupby}{grouping columns.}

\item{...}{new column assignment expressions.}

\item{env}{environment to look for values in.}
}
\value{
project node.
}
\description{
project data by grouping, and adding aggregate columns.
}
\examples{

my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
d <- dbi_copy_to(my_db, 'd',
                data.frame(AUC = 0.6, R2 = 0.2))
eqn <- project_nse(d, "AUC", v := max(R2))
cat(format(eqn))
sql <- to_sql(eqn, my_db)
cat(sql)
DBI::dbGetQuery(my_db, sql)
DBI::dbDisconnect(my_db)

}
