% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_rrd.R
\name{read_rrd}
\alias{read_rrd}
\title{Imports data from an RRD database}
\usage{
read_rrd(filename)
}
\arguments{
\item{filename}{File name}
}
\value{
Returns a named list of data.frames. Each data frame corresponds to an RRA (see \code{\link[=read_rra]{read_rra()}}).  The list has names constructed as "consolidation function" + "step" - e.g. "AVERAGE15".
}
\description{
Reads the metadata in the RRD and adjusts the parameters accordingly in order to expose all RRAs in their entirety.
}
\examples{
rrd_cpu_0 <- system.file("extdata/cpu-0.rrd", package = "rrd")

describe_rrd(rrd_cpu_0)

cpu <- read_rrd(rrd_cpu_0)
names(cpu)
head(cpu[[1]])
tail(cpu[[1]])

tail(
  cpu$AVERAGE60$sys
)
}
\references{
\url{https://oss.oetiker.ch/rrdtool/doc/rrdfetch.en.html}
}
\seealso{
Other rrd functions: 
\code{\link{describe_rrd}()},
\code{\link{read_rra}()}
}
\concept{rrd functions}
