% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pedindex.R
\name{get.pedindex}
\alias{get.pedindex}
\title{Get pedigree index.}
\usage{
get.pedindex(pedinfo, member.set)
}
\arguments{
\item{pedinfo}{dataframe.}

\item{member.set}{character vector.}
}
\value{
An integer vector of indices for each individual of interest found in \code{pedinfo}.
}
\description{
\code{get.pedindex} returns indices of individuals in the pedigree.
}
\details{
\code{member.set} contains member IDs of individuals of interest.
}
\examples{
# a simple pedigree with sibling marriage
pedigree = as.character(rep(1, 5))
member = as.character(c(11, 12, 21, 22, 31))
sex = as.numeric(c(1, 2, 1, 2, 1))
father = as.character(c(NA, NA, 11, 11, 21))
mother = as.character(c(NA, NA, 12, 12, 22))
pedinfo = data.frame(pedigree, member, sex, father, mother, stringsAsFactors = FALSE)

get.pedindex(pedinfo, c("22", "31"))
}
