/*
 * Decompiled with CFR 0.152.
 */
package rreval;

import java.io.Serializable;
import rreval.ConnectionJ;
import rreval.Verbose;
import rreval.WriteException;

public class JWriter {
    public static int MAX_WRITE_RETRIES = 16;
    public static long RETRY_NAP = 500L;
    ConnectionJ con;

    public JWriter(ConnectionJ con) {
        this.con = con;
    }

    public void writeMessage(Serializable obj) throws Exception {
        Exception z = null;
        for (int i = 0; i < MAX_WRITE_RETRIES; ++i) {
            try {
                this.con.write(obj);
                if (this.readAck()) {
                    return;
                }
                try {
                    Thread.sleep(RETRY_NAP);
                }
                catch (InterruptedException ix) {}
                continue;
            }
            catch (Exception xxx) {
                if (xxx instanceof RuntimeException && !(xxx instanceof ClassCastException)) {
                    throw (RuntimeException)xxx;
                }
                z = xxx;
            }
        }
        Verbose.show("JWriter.writeM: max tries exceeded");
        if (z != null) {
            Verbose.show("JWriter.writeM: thowing ", z);
            throw z;
        }
        Verbose.show("JWriter.writeM: throwing write faile exception");
        throw new WriteException("Write object failed after " + MAX_WRITE_RETRIES + " tries.");
    }

    boolean readAck() throws Exception {
        Boolean ack = (Boolean)this.con.read();
        return ack;
    }
}

