% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df2flextable.R
\name{df2flextable}
\alias{df2flextable}
\title{Convert data.frame to flextable}
\usage{
df2flextable(df, vanilla = FALSE, fontname = NULL, fontsize = 10,
  add.rownames = FALSE, even_header = "transparent",
  odd_header = "#5B7778", even_body = "#EFEFEF", odd_body = "transparent",
  vlines = TRUE, colorheader = FALSE, digits = 2,
  align_header = "center", align_body = "right", NA2space = FALSE,
  pcol = NULL, ...)
}
\arguments{
\item{df}{A data.frame}

\item{vanilla}{A Logical}

\item{fontname}{Font name}

\item{fontsize}{font size}

\item{add.rownames}{logical. Whether or not include rownames}

\item{even_header}{background color of even_header}

\item{odd_header}{background color of even_header}

\item{even_body}{background color of even_body}

\item{odd_body}{background color of even_body}

\item{vlines}{Logical. Whether or not draw vertical lines}

\item{colorheader}{Logical. Whether or not use color in header}

\item{digits}{integer indicating the number of decimal places}

\item{align_header}{alignment of header. Expected value is one of 'left', 'right', 'center', 'justify'.}

\item{align_body}{alignment of body. Expected value is one of 'left', 'right', 'center', 'justify'.}

\item{NA2space}{A logical. If true, convert NA value to space}

\item{pcol}{An integer indicating p value. If specified, convert value less than 0.01 to "< 0.001" in given column.}

\item{...}{further arguments to be passed to flextable}
}
\description{
Convert data.frame to flextable
}
\examples{
require(flextable)
require(officer)
df2flextable(head(iris),vanilla=TRUE,colorheader=TRUE)
df2flextable(head(iris),vanilla=TRUE,digits=c(1,2,3,4))
df2flextable(head(iris),vanilla=FALSE)
df2flextable(head(iris),vanilla=FALSE,vlines=FALSE,fontsize=14)
df2flextable(head(mtcars))
}
