% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/records.R, R/rtoi.R
\name{dates}
\alias{dates}
\alias{dates,records-method}
\alias{dates<-}
\alias{dates<-,records-method}
\alias{dates,rtoi-method}
\title{Get/set the dates from a \code{records} or an \code{rtoi}}
\usage{
dates(x)

\S4method{dates}{records}(x)

dates(x) <- value

\S4method{dates}{records}(x) <- value

\S4method{dates}{rtoi}(x)
}
\arguments{
\item{x}{a \code{records} or an \code{rtoi} object.}

\item{value}{the new date to asign}
}
\value{
returns a vector of \code{Date} class
}
\description{
Get/set the dates from a \code{records} or an \code{rtoi}
}
\examples{
\dontrun{
# load example rtoi
file.copy(from=system.file("ex/Navarre",package="rsat"),
         to=tempdir(),
         recursive = TRUE)

navarre <- read_rtoi(file.path(tempdir(),"Navarre"))

# get a vector of dates includes in rtoi
dates(navarre)

# get the records
rcds <- records(navarre)

# coerce the records to dataframr
dates(rcds)
}
}
