% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/records.R
\name{get_api_name}
\alias{get_api_name}
\alias{get_api_name,records-method}
\alias{get_api_name,records}
\title{Get the API name of a \code{records}}
\usage{
get_api_name(x)

\S4method{get_api_name}{records}(x)
}
\arguments{
\item{x}{a \code{records} object.}
}
\value{
a character vector containing the API names of the
elements in \code{x}.
}
\description{
A function to get or set the api names of an object.
}
\examples{
\dontrun{
# load example rtoi
file.copy(from=system.file("ex/Navarre",package="rsat"),
         to=tempdir(),
         recursive = TRUE)

navarre <- read_rtoi(file.path(tempdir(),"Navarre"))

# get the records
rcds <- records(navarre)

# get a vector with the api name of each records
get_api_name(rcds)
}
}
