% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extent_crs.R, R/records.R
\name{length,extent_crs-method}
\alias{length,extent_crs-method}
\alias{length,records-method}
\title{Length of an object}
\usage{
\S4method{length}{extent_crs}(x)

\S4method{length}{records}(x)
}
\arguments{
\item{x}{a \code{records} object to compute its length.}
}
\value{
Length currently returns a non-negative integer of length 1
}
\description{
Get or set the length of vectors (including lists) and factors,
and of any other R object for which a method has been defined.
}
\examples{
\dontrun{
# load example rtoi
file.copy(from=system.file("ex/Navarre",package="rsat"),
         to=tempdir(),
         recursive = TRUE)

navarre <- read_rtoi(file.path(tempdir(),"Navarre"))

# get the records
rcds <- records(navarre)

length(rcds)
}
}
