% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsat_download.R
\name{rsat_download}
\alias{rsat_download}
\alias{rsat_download,rtoi-method}
\alias{rsat_download,rtoi}
\alias{rsat_download,records-method}
\alias{rsat_download,records}
\title{Download the images from a \code{records} or an \code{rtoi} object}
\usage{
rsat_download(x, ...)

\S4method{rsat_download}{rtoi}(x, db_path, verbose = FALSE, test.mode = FALSE, ...)

\S4method{rsat_download}{records}(x, out.dir, verbose = FALSE, test.mode = FALSE, ...)
}
\arguments{
\item{x}{a \code{records} or an \code{rtoi} object.}

\item{...}{additional arguments.}

\item{db_path}{path to the database. By default, the path
is defined by the \code{rtoi}.}

\item{verbose}{logical argument. If \code{TRUE}, the function prints the
running steps and warnings.}

\item{test.mode}{logical argument. If \code{TRUE}, the function gets test
data from github.}

\item{out.dir}{path where the outputs are stored when using a \code{records}.}
}
\value{
nothing. Downloads the images into your database
}
\description{
The function saves the raw images in the database or the specified directory.
It skips the images that already exist in the database or directory.
}
\examples{
\dontrun{
library(rsat)

# create a copy of navarre in temp file
file.copy(from=system.file("ex/Navarre",package="rsat"),
         to=tempdir(),
         recursive = TRUE)

# load example rtoi
navarre <- read_rtoi(file.path(tempdir(),"Navarre"))

# assign the path of the database
set_database(file.path(tempdir(),"DATABASE"))
rsat_download(navarre)

rcrds <-  records(navarre)

rsat_download(rcrds)
}
}
