testthat::context("kable")

testthat::test_that("Output is of class 'knitr_kable' for simsum", {
  s <- simsum(data = tt, estvarname = "diff", se = "se", true = -1)
  testthat::expect_s3_class(object = kable(s), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, digits = 2), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, format = "latex"), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, stats = "bias"), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, stats = c("bias", "cover")), class = "knitr_kable")

  s <- simsum(data = tt, estvarname = "diff", methodvar = "method", se = "se", true = -1)
  testthat::expect_s3_class(object = kable(s), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, digits = 2), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, format = "latex"), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, stats = "bias"), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, stats = c("bias", "cover")), class = "knitr_kable")

  s <- simsum(data = tt, estvarname = "diff", by = "dgm", se = "se", true = -1)
  testthat::expect_s3_class(object = kable(s), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, digits = 2), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, format = "latex"), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, stats = "bias"), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, stats = c("bias", "cover")), class = "knitr_kable")

  s <- simsum(data = tt, estvarname = "diff", methodvar = "method", by = "dgm", se = "se", true = -1)
  testthat::expect_s3_class(object = kable(s), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, digits = 2), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, format = "latex"), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, stats = "bias"), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, stats = c("bias", "cover")), class = "knitr_kable")
})

testthat::test_that("Output is of class 'knitr_kable' for summary.simsum", {
  s <- simsum(data = tt, estvarname = "diff", se = "se", true = -1)
  s <- summary(s)
  testthat::expect_s3_class(object = kable(s), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, digits = 2), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, format = "latex"), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, stats = "bias"), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, stats = c("bias", "cover")), class = "knitr_kable")

  s <- simsum(data = tt, estvarname = "diff", methodvar = "method", se = "se", true = -1)
  s <- summary(s)
  testthat::expect_s3_class(object = kable(s), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, digits = 2), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, format = "latex"), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, stats = "bias"), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, stats = c("bias", "cover")), class = "knitr_kable")

  s <- simsum(data = tt, estvarname = "diff", by = "dgm", se = "se", true = -1)
  testthat::expect_s3_class(object = kable(s), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, digits = 2), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, format = "latex"), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, stats = "bias"), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, stats = c("bias", "cover")), class = "knitr_kable")

  s <- simsum(data = tt, estvarname = "diff", methodvar = "method", by = "dgm", se = "se", true = -1)
  s <- summary(s)
  testthat::expect_s3_class(object = kable(s), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, digits = 2), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, format = "latex"), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, stats = "bias"), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, stats = c("bias", "cover")), class = "knitr_kable")
})

testthat::test_that("Output is of class 'knitr_kable' for multisimsum", {
  data("frailty", package = "rsimsum")
  s <- multisimsum(data = frailty, par = "par", true = c(trt = -0.50, fv = 0.75), estvarname = "b", se = "se")
  testthat::expect_s3_class(object = kable(s), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, digits = 2), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, format = "latex"), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, stats = "bias"), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, stats = c("bias", "cover")), class = "knitr_kable")

  data("frailty", package = "rsimsum")
  s <- multisimsum(data = frailty, par = "par", true = c(trt = -0.50, fv = 0.75), estvarname = "b", se = "se", methodvar = "model")
  testthat::expect_s3_class(object = kable(s), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, digits = 2), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, format = "latex"), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, stats = "bias"), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, stats = c("bias", "cover")), class = "knitr_kable")

  data("frailty", package = "rsimsum")
  s <- multisimsum(data = frailty, par = "par", true = c(trt = -0.50, fv = 0.75), estvarname = "b", se = "se", by = "fv_dist")
  testthat::expect_s3_class(object = kable(s), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, digits = 2), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, format = "latex"), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, stats = "bias"), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, stats = c("bias", "cover")), class = "knitr_kable")

  data("frailty", package = "rsimsum")
  s <- multisimsum(data = frailty, par = "par", true = c(trt = -0.50, fv = 0.75), estvarname = "b", se = "se", methodvar = "model", by = "fv_dist")
  testthat::expect_s3_class(object = kable(s), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, digits = 2), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, format = "latex"), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, stats = "bias"), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, stats = c("bias", "cover")), class = "knitr_kable")
})

testthat::test_that("Output is of class 'knitr_kable' for summary.multisimsum", {
  data("frailty", package = "rsimsum")
  s <- multisimsum(data = frailty, par = "par", true = c(trt = -0.50, fv = 0.75), estvarname = "b", se = "se")
  s <- summary(s)
  testthat::expect_s3_class(object = kable(s), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, digits = 2), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, format = "latex"), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, stats = "bias"), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, stats = c("bias", "cover")), class = "knitr_kable")

  data("frailty", package = "rsimsum")
  s <- multisimsum(data = frailty, par = "par", true = c(trt = -0.50, fv = 0.75), estvarname = "b", se = "se", methodvar = "model")
  s <- summary(s)
  testthat::expect_s3_class(object = kable(s), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, digits = 2), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, format = "latex"), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, stats = "bias"), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, stats = c("bias", "cover")), class = "knitr_kable")

  data("frailty", package = "rsimsum")
  s <- multisimsum(data = frailty, par = "par", true = c(trt = -0.50, fv = 0.75), estvarname = "b", se = "se", by = "fv_dist")
  s <- summary(s)
  testthat::expect_s3_class(object = kable(s), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, digits = 2), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, format = "latex"), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, stats = "bias"), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, stats = c("bias", "cover")), class = "knitr_kable")

  data("frailty", package = "rsimsum")
  s <- multisimsum(data = frailty, par = "par", true = c(trt = -0.50, fv = 0.75), estvarname = "b", se = "se", methodvar = "model", by = "fv_dist")
  s <- summary(s)
  testthat::expect_s3_class(object = kable(s), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, digits = 2), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, format = "latex"), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, stats = "bias"), class = "knitr_kable")
  testthat::expect_s3_class(object = kable(s, stats = c("bias", "cover")), class = "knitr_kable")
})
