% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signatures.R
\name{items_sign_planetary_computer}
\alias{items_sign_planetary_computer}
\alias{sign_planetary_computer}
\title{Signs URL to access assets from Microsoft's Planetary Computer.}
\usage{
items_sign_planetary_computer(items, subscription_key = NULL, ...)

sign_planetary_computer(..., headers = NULL, token_url = NULL)
}
\arguments{
\item{items}{a \code{doc_item} or \code{doc_items} object
representing the result of \verb{/stac/search},
\code{/collections/{collectionId}/items} or
\code{/collections/{collectionId}/items/{itemId}} endpoints.}

\item{subscription_key}{the \code{subscription-key} to access restricted
assets in Microsoft Planetary Computer. You can keep this parameter
empty for non-protected assets.}

\item{...}{additional parameters can be supplied to the \code{GET} function
of the \code{httr} package.}

\item{headers}{a named character vector with headers key-value content.}

\item{token_url}{a \code{character} with the URL that generates the tokens
in the Microsoft service.
By default is used:
\code{"https://planetarycomputer.microsoft.com/api/sas/v1/token"}}
}
\value{
\itemize{
\item \code{items_sign_planetary_computer()}: items with signed assets URLs.

\item \code{sign_planetary_computer()}: a function to to be passed to
\code{items_sign()}.
}
}
\description{
These functions provide support to access assets from Planetary Computer.

\itemize{
\item \code{items_sign_planetary_computer()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
A simplified function to sign assets' URL from Microsoft Planetary
Computer to be able to access the data.

\item \code{sign_planetary_computer()}: Creates a signing function to be
used by \code{items_sign()}. This function sign all the assets' URL.
}
}
\examples{
\dontrun{
 # doc_items object
 stac_obj <- stac("https://planetarycomputer.microsoft.com/api/stac/v1/") \%>\%
  stac_search(collections = "sentinel-2-l2a",
              bbox = c(-47.02148, -17.35063, -42.53906, -12.98314)) \%>\%
  get_request()

 # the new way to authenticate:
 stac_obj <- stac_obj \%>\%
   items_sign_planetary_computer()

 # this is the old way of authentication (still works):
 # stac_obj <- stac_obj \%>\%
 #   items_sign(sign_fn = sign_planetary_computer())

 # example of access to collections that require authentication
 stac_obj <- stac("https://planetarycomputer.microsoft.com/api/stac/v1") \%>\%
   stac_search(collections = c("sentinel-1-rtc"),
               bbox = c(-64.8597, -10.4919, -64.79272527, -10.4473),
               datetime = "2019-01-01/2019-01-28") \%>\%
   post_request()

 # the new way to authenticate:
 # stac_obj <- stac_obj \%>\%
 #   items_sign_planetary_computer("<subscription-key>")

 # this is the old way of authentication (still works):
 # stac_obj <- stac_obj \%>\%
 #   items_sign(
 #     sign_fn = sign_planetary_computer(
 #       headers = c("Ocp-Apim-Subscription-Key" = <your-mpc-token>)
 #     )
 #   )
}

}
