% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_summary.R
\name{prior_summary.stanreg}
\alias{prior_summary}
\alias{prior_summary.stanreg}
\title{Extract and/or print a summary of the priors used for an rstanarm model}
\usage{
\method{prior_summary}{stanreg}(object, digits = 2, ...)
}
\arguments{
\item{object}{A fitted model object returned by one of the 
\pkg{rstanarm} modeling functions. See \code{\link{stanreg-objects}}.}

\item{digits}{Number of digits to use for rounding.}

\item{...}{Currently ignored by the method for stanreg objects. The S3
generic uses \code{...} to pass arguments to any defined methods.}
}
\value{
A list of class "prior_summary.stanreg", which has its own print
  method.
}
\description{
Extract and/or print a summary of the priors used for an rstanarm model
}
\details{
For some models you may see "\code{adjusted scale}" in the printed 
  output and adjusted scales included in the object returned by 
  \code{prior_summary}. These adjusted scale values are the prior scales 
  actually used by \pkg{rstanarm} and are computed by adjusting the prior
  scales specified by the user to account for the scales of the predictors
  (as described in the documentation for the \code{scaled} argument to 
  \code{\link{prior_options}}). For models with adjusted prior scales, 
  refitting the model with \code{prior_ops=prior_options(scaled=FALSE)} will
  disable this feature.
}
\examples{
if (!exists("example_model")) example(example_model) 
prior_summary(example_model)

priors <- prior_summary(example_model)
names(priors)
priors$prior$scale
priors$prior$adjusted_scale

# for a glm with adjusted scales (see Details, above), compare 
# the default (rstanarm adjusting the scales) to setting 
# prior_ops=prior_options(scaled=FALSE)
fit <- stan_glm(mpg ~ wt + am, data = mtcars, 
                prior = normal(0, c(2.5, 4)), 
                prior_intercept = normal(0, 5), 
                iter = 10, chains = 1) # only for demonstration 
prior_summary(fit)

fit2 <- update(fit, prior_ops = prior_options(scaled = FALSE))
prior_summary(fit2)

}

