% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo.R
\name{loo.stanreg}
\alias{compare_models}
\alias{kfold}
\alias{loo}
\alias{loo.stanreg}
\alias{waic}
\alias{waic.stanreg}
\title{Information criteria and cross-validation}
\usage{
\method{loo}{stanreg}(x, ..., k_threshold = NULL)

\method{waic}{stanreg}(x, ...)

kfold(x, K = 10, save_fits = FALSE)

compare_models(..., loos = list())
}
\arguments{
\item{x}{A fitted model object returned by one of the 
\pkg{rstanarm} modeling functions. See \code{\link{stanreg-objects}}.}

\item{...}{For the \code{loo} method, \code{...} can be used to pass optional
arguments (e.g. \code{cores}) to \code{\link[loo]{psislw}}. For 
\code{compare_models}, \code{...} should contain two or more objects 
returned by the \code{loo}, \code{kfold}, or \code{waic} method (see the 
\strong{Examples} section, below).}

\item{k_threshold}{Threshold for flagging estimates of the Pareto shape 
parameters \eqn{k} estimated by \code{loo}. See the \emph{How to proceed
when \code{loo} gives warnings} section, below, for details.}

\item{K}{For \code{kfold}, the number of subsets of equal (if possible) size
into which the data will be randomly partitioned for performing
\eqn{K}-fold cross-validation. The model is refit \code{K} times, each time
leaving out one of the \code{K} subsets. If \code{K} is equal to the total
number of observations in the data then \eqn{K}-fold cross-validation is
equivalent to exact leave-one-out cross-validation.}

\item{save_fits}{If \code{TRUE}, a component 'fits' is added to the returned
object to store the cross-validated \link[=stanreg-objects]{stanreg}
objects and the indices of the omitted observations for each fold. Defaults
to \code{FALSE}.}

\item{loos}{For \code{compare_models}, a list of two or more objects returned
by the \code{loo}, \code{kfold}, or \code{waic} method. This argument can 
be used as an alternative to passing these objects via \code{...}.}
}
\value{
The \code{loo} and \code{waic} methods return an object of class
  'loo'. See the \strong{Value} section in \code{\link[loo]{loo}} and 
  \code{\link[loo]{waic}} (from the \pkg{loo} package) for details on the 
  structure of these objects.

\code{kfold} returns an object with has classes 'kfold' and 'loo' 
  that has a similar structure as the objects returned by the \code{loo} and
  \code{waic} methods.

\code{compare_models} returns a vector or matrix with class 
  'compare.loo'. See the \strong{Comparing models} section below for more
  details.
}
\description{
For models fit using MCMC, compute approximate leave-one-out cross-validation
(LOO, LOOIC) or, less preferably, the Widely Applicable Information Criterion
(WAIC) using the \pkg{\link[=loo-package]{loo}} package. Exact \eqn{K}-fold 
cross-validation is also available. Compare two or more models using the 
\code{compare_models} function. \strong{Note:} these functions are not 
guaranteed to work properly unless the \code{data} argument was specified 
when the model was fit.
}
\section{Approximate LOO CV}{
 The \code{loo} method for stanreg objects
  provides an interface to the \pkg{\link[=loo-package]{loo}} package for
  approximate leave-one-out cross-validation (LOO). The LOO Information
  Criterion (LOOIC) has the same purpose as the Akaike Information Criterion
  (AIC) that is used by frequentists. Both are intended to estimate the
  expected log predictive density (ELPD) for a new dataset. However, the AIC
  ignores priors and assumes that the posterior distribution is multivariate
  normal, whereas the functions from the \pkg{loo} package do not make this
  distributional assumption and integrate over uncertainty in the parameters.
  This only assumes that any one observation can be omitted without having a
  major effect on the posterior distribution, which can be judged using the
  diagnostic plot provided by the \code{\link[loo]{plot.loo}} method and the
  warnings provided by the \code{\link[loo]{print.loo}} method (see the
  \emph{How to Use the rstanarm Package} vignette for an example of this
  process).
  
  \subsection{How to proceed when \code{loo} gives warnings (k_threshold)}{ 
  The \code{k_threshold} argument to the \code{loo} method for \pkg{rstanarm}
  models is provided as a possible remedy when the diagnostics reveal
  problems stemming from the posterior's sensitivity to particular
  observations. Warnings about Pareto \eqn{k} estimates indicate observations
  for which the approximation to LOO is problematic (this is described in
  detail in Vehtari, Gelman, and Gabry (2016) and the
  \pkg{\link[=loo-package]{loo}} package documentation). The
  \code{k_threshold} argument can be used to set the \eqn{k} value above
  which an observation is flagged. If \code{k_threshold} is not \code{NULL}
  and there are \eqn{J} observations with \eqn{k} estimates above
  \code{k_threshold} then when \code{loo} is called it will refit the 
  original model \eqn{J} times, each time leaving out one of the \eqn{J} 
  problematic observations. The pointwise contributions of these observations
  to the total ELPD are then computed directly and substituted for the
  previous estimates from these \eqn{J} observations that are stored in the
  object created by \code{loo}.
  
  \strong{Note}: in the warning messages issued by \code{loo} about large 
  Pareto \eqn{k} estimates we recommend setting \code{k_threshold} to at
  least \eqn{0.7}. There is a theoretical reason, explained in Vehtari,
  Gelman, and Gabry (2016), for setting the threshold to the stricter value
  of \eqn{0.5}, but in practice they find that errors in the LOO
  approximation start to increase non-negligibly when \eqn{k > 0.7}. 
  }
}

\section{K-fold CV}{
 The \code{kfold} function performs exact \eqn{K}-fold
  cross-validation. First the data are randomly partitioned into \eqn{K}
  subsets of equal (or as close to equal as possible) size. Then the model is
  refit \eqn{K} times, each time leaving out one of the \code{K} subsets. If
  \eqn{K} is equal to the total number of observations in the data then
  \eqn{K}-fold cross-validation is equivalent to exact leave-one-out
  cross-validation (to which \code{loo} is an efficient approximation). The
  \code{compare_models} function is also compatible with the objects returned
  by \code{kfold}.
}

\section{Comparing models}{
 \code{compare_models} is a wrapper around the
  \code{\link[loo]{compare}} function in the \pkg{loo} package. Before
  calling \code{compare}, \code{compare_models} performs some extra checks to
  make sure the \pkg{rstanarm} models are suitable for comparison. These
  extra checks include verifying that all models to be compared were fit
  using the same outcome variable and likelihood family.
  
  If exactly two models are being compared then \code{compare_models} returns
  a vector containing the difference in expected log predictive density 
  (ELPD) between the models and the standard error of that difference (the 
  documentation for \code{\link[loo]{compare}} has additional details about 
  the calculation of the standard error of the difference). The difference in
  ELPD will be negative if the expected out-of-sample predictive accuracy of
  the first model is higher. If the difference is be positive then the second
  model is preferred.
  
  If more than two models are being compared then \code{compare_models} 
  returns a matrix with one row per model. This matrix summarizes the objects
  and arranges them in descending order according to expected out-of-sample
  predictive accuracy. That is, the first row of the matrix will be 
  for the model with the largest ELPD (smallest LOOIC).
}
\examples{
\donttest{
fit1 <- stan_glm(mpg ~ wt, data = mtcars)
fit2 <- stan_glm(mpg ~ wt + cyl, data = mtcars)

# compare on LOOIC
(loo1 <- loo(fit1, cores = 2))
loo2 <- loo(fit2, cores = 2)
plot(loo2)

# when comparing exactly two models, the reported 'elpd_diff' will be 
# positive if the expected predictive accuracy for the second model is higher
compare_models(loo1, loo2) # or compare_models(loos = list(loo1, loo2))

# when comparing three or more models they are ordered by expected
# predictive accuracy
fit3 <- stan_glm(mpg ~ ., data = mtcars)
loo3 <- loo(fit3, k_threshold = 0.7, cores = 2)
compare_models(loo1, loo2, loo3)

# 10-fold cross-validation
(kfold1 <- kfold(fit1, K = 10))
kfold2 <- kfold(fit2, K = 10)
compare_models(kfold1, kfold2)
}

}
\references{
Vehtari, A., Gelman, A., and Gabry, J. (2016a). Practical
  Bayesian model evaluation using leave-one-out cross-validation and WAIC.
  \emph{Statistics and Computing}. Advance online publication.
  doi:10.1007/s11222-016-9696-4. arXiv preprint:
  \url{http://arxiv.org/abs/1507.04544/}
}
\seealso{
\itemize{
  \item The various \pkg{rstanarm} vignettes for more examples of 
    using \code{loo} and \code{compare_models}.
  \item \code{\link[loo]{loo-package}} (in particular the \emph{PSIS-LOO} 
    section)  for details on the computations implemented by the \pkg{loo} 
    package and the interpretation of the Pareto \eqn{k} estimates displayed 
    when using the  \code{\link{plot.loo}} method.
  \item \code{\link{log_lik.stanreg}} to directly access the pointwise 
    log-likelihood matrix. 
}
}

