% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stap_glm.R
\name{stap_glm}
\alias{stap_glm}
\alias{stap_lm}
\title{Bayesian generalized spatial-temporal aggregated predictor(STAP) models via Stan}
\usage{
stap_glm(formula, family = gaussian(), subject_data = NULL,
  distance_data = NULL, time_data = NULL, subject_ID = NULL,
  max_distance = NULL, max_time = NULL, weights, offset = NULL,
  model = TRUE, y = TRUE, contrasts = NULL, ..., prior = normal(),
  prior_intercept = normal(), prior_stap = normal(),
  prior_theta = log_normal(location = 1L, scale = 1L),
  prior_aux = exponential(), adapt_delta = NULL)

stap_lm(formula, family = gaussian(), subject_data = NULL,
  distance_data = NULL, time_data = NULL, subject_ID = NULL,
  max_distance = NULL, max_time = NULL, weights, offset = NULL,
  model = TRUE, y = TRUE, contrasts = NULL, ..., prior = normal(),
  prior_intercept = normal(), prior_stap = normal(),
  prior_theta = log_normal(location = 1L, scale = 1L),
  prior_aux = exponential(), adapt_delta = NULL)
}
\arguments{
\item{formula}{Same as for \code{\link[stats]{glm}}. Note that in-formula transformations will not be passed ot the final design matrix. Covariates that have "scale" in their name are not advised as this text is parsed for in the final model fit.}

\item{family}{Same as \code{\link[stats]{glm}} for gaussian, binomial, and poisson families.}

\item{subject_data}{a data.frame that contains data specific to the subject or subjects on whom the outcome is measured. Must contain one column that has the subject_ID  on which to join the distance and time_data}

\item{distance_data}{a (minimum) three column data.frame that contains (1) an id_key (2) The sap/tap/stap features and (3) the distances between subject with a given id and the built environment feature in column (2), the distance column must be the only column of type "double" and the sap/tap/stap features must be specified in the dataframe exactly as they are in the formula.}

\item{time_data}{same as distance_data except with time that the subject has been exposed to the built environment feature, instead of distance}

\item{subject_ID}{name of column(s) to join on between subject_data and bef_data}

\item{max_distance}{the inclusion distance; upper bound for all elements of dists_crs}

\item{max_time}{inclusion time; upper bound for all elements of times_crs}

\item{offset, weights}{Same as \code{\link[stats]{glm}}.}

\item{model}{logical denoting whether or not to return the fixed covariates model frame object in the fitted object}

\item{y}{In \code{stap_glm}, logical scalar indicating whether to return the response vector. In \code{stan_glm.fit}, a response vector.}

\item{contrasts}{Same as \code{\link[stats]{glm}}, but
rarely specified.}

\item{...}{Further arguments passed to the function in the \pkg{rstap} 
to specify \code{iter}, \code{chains}, \code{cores}, \code{refresh}, etc.}

\item{prior}{The prior distribution for the regression coefficients. 
\code{prior} should be a call to one of the various functions provided by 
\pkg{rstap} for specifying priors. The subset of these functions that 
can be used for the prior on the coefficients can be grouped into several 
"families":

\tabular{ll}{
  \strong{Family} \tab \strong{Functions} \cr 
  \emph{Student t family} \tab \code{normal}, \code{student_t}, \code{cauchy} \cr 
  \emph{Hierarchical shrinkage family} \tab \code{hs}, \code{hs_plus} \cr 
  \emph{Laplace family} \tab \code{laplace}, \code{lasso} \cr
  \emph{Product normal family} \tab \code{product_normal} \cr
}

See the \link[=priors]{priors help page} for details on the families and 
how to specify the arguments for all of the functions in the table above.
To omit a prior ---i.e., to use a flat (improper) uniform prior---
\code{prior} can be set to \code{NULL}, although this is rarely a good
idea.

\strong{Note:} If \code{prior} is from the Student t
family or Laplace family, and if the \code{autoscale} argument to the 
function used to specify the prior (e.g. \code{\link{normal}}) is left at 
its default and recommended value of \code{TRUE}, then the default or 
user-specified prior scale(s) may be adjusted internally based on the
scales of the predictors. See the \link[=priors]{priors help page} and the
\emph{Prior Distributions} vignette for details on the rescaling and the
\code{\link{prior_summary}} function for a summary of the priors used for a
particular model.}

\item{prior_intercept}{The prior distribution for the intercept. 
\code{prior_intercept} can be a call to \code{normal}, \code{student_t} or 
\code{cauchy}. See the \link[=priors]{priors help page} for details on 
these functions. To omit a prior on the intercept ---i.e., to use a flat
(improper) uniform prior--- \code{prior_intercept} can be set to
\code{NULL}.

\strong{Note:} The prior distribution for the intercept is set so it
applies to the value \emph{when all predictors are centered}. If you prefer
to specify a prior on the intercept without the predictors being
auto-centered, then you have to omit the intercept from the
\code{\link[stats]{formula}} and include a column of ones as a predictor,
in which case some element of \code{prior} specifies the prior on it,
rather than \code{prior_intercept}. Regardless of how
\code{prior_intercept} is specified, the reported \emph{estimates} of the
intercept always correspond to a parameterization without centered
predictors (i.e., same as in \code{glm}).}

\item{prior_stap}{prior for spatial-temporal aggregated predictors. Note that prior is set on the standardized latent covariates.}

\item{prior_theta}{prior for the spatial-temporal aggregated predictors' scale. Can either be a single prior or a prior nested within a list of lists.}

\item{prior_aux}{The prior distribution for the "auxiliary" parameter (if
applicable). The "auxiliary" parameter refers to a different parameter 
depending on the \code{family}. For Gaussian models \code{prior_aux} 
controls \code{"sigma"}, the error 
standard deviation. For negative binomial models \code{prior_aux} controls 
\code{"reciprocal_dispersion"}, which is similar to the 
\code{"size"} parameter of \code{\link[stats]{rnbinom}}:
smaller values of \code{"reciprocal_dispersion"} correspond to 
greater dispersion. For gamma models \code{prior_aux} sets the prior on 
to the \code{"shape"} parameter (see e.g., 
\code{\link[stats]{rgamma}}), and for inverse-Gaussian models it is the 
so-called \code{"lambda"} parameter (which is essentially the reciprocal of
a scale parameter). Binomial and Poisson models do not have auxiliary 
parameters. 

\code{prior_aux} can be a call to \code{exponential} to 
use an exponential distribution, or \code{normal}, \code{student_t} or 
\code{cauchy}, which results in a half-normal, half-t, or half-Cauchy 
prior. See \code{\link{priors}} for details on these functions. To omit a 
prior ---i.e., to use a flat (improper) uniform prior--- set 
\code{prior_aux} to \code{NULL}.}

\item{adapt_delta}{See the \link{adapt_delta} help page for details.}
}
\value{
A \link[=stapreg-objects]{stapreg} object is returned 
for \code{stap_glm}.

A \link[=stanfit-class]{stapfit} object (or a slightly modified 
  stapfit object) is returned if \code{stan_glm.fit} is called directly.
}
\description{
Generalized linear modeling with spatial temporal aggregated predictors using
prior distributions for the coefficients, intercept, spatial-temporal scales, and auxiliary parameters.
}
\details{
The \code{stap_glm} function is similar in syntax to
\code{\link[rstanarm]{stan_glm}} except instead of performing full bayesian
inference for a generalized linear model stap_glm incorporates spatial-temporal covariates
}
\examples{

fit_glm <- stap_glm(formula = y ~ sex + sap(Fast_Food),
                   subject_data = homog_subject_data[1:100,], # for speed of example only
                     distance_data = homog_distance_data,
                     family = gaussian(link = 'identity'),
                     subject_ID = 'subj_id',
                     prior = normal(location = 0, scale = 5, autoscale = FALSE),
                     prior_intercept = normal(location = 25, scale = 5, autoscale = FALSE),
                     prior_stap = normal(location = 0, scale = 3, autoscale = FALSE),
                     prior_theta = log_normal(location = 1, scale = 1),
                     prior_aux = cauchy(location = 0,scale = 5),
                     max_distance = max(homog_distance_data$Distance),
                     chains = 1, iter = 300, # for speed of example only
                     refresh = -1, verbose = FALSE) 

}
\references{
Gelman, A. and Hill, J. (2007). \emph{Data Analysis Using
  Regression and Multilevel/Hierarchical Models.} Cambridge University Press,
  Cambridge, UK.

Muth, C., Oravecz, Z., and Gabry, J. (2018)
User-friendly Bayesian regression modeling: A tutorial with rstanarm and shinystan.
\emph{The Quantitative Methods for Psychology}. 14(2), 99--119.
\url{https://www.tqmp.org/RegularArticles/vol14-2/p099/p099.pdf}
}
\seealso{
\code{\link{stapreg-methods}} and 
\code{\link[stats]{glm}}.

The various vignettes for \code{stap_glm} at
  \url{https://biostatistics4socialimpact.github.io/rstap/articles} and the \href{http://arxiv.org/abs/1812.10208}{preprint} article.
}
