/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Group<T> {
    private final Set<T> elements;
    private final String id;
    private boolean root;
    private List<Group<T>> subsets;

    public Group(String id) {
        this.id = id;
        this.elements = new HashSet<T>();
        this.root = true;
    }

    public void addElement(T newElement) {
        this.elements.add(newElement);
    }

    public void addSubset(Group<T> newGroup) {
        if (this.subsets == null) {
            this.subsets = new ArrayList<Group<T>>();
        }
        this.subsets.add(newGroup);
        newGroup.root = false;
    }

    private void appendDashes(StringBuffer result, int praefix) {
        int i = 0;
        while (i < praefix) {
            result.append("-");
            ++i;
        }
    }

    public Set<T> getDirectElements() {
        return this.elements;
    }

    public List<T> getElements() {
        HashSet<T> result = new HashSet<T>();
        result.addAll(this.elements);
        if (this.subsets != null) {
            for (Group<T> sub : this.subsets) {
                result.addAll(sub.getElements());
            }
        }
        ArrayList<T> resultList = new ArrayList<T>();
        resultList.addAll(result);
        return resultList;
    }

    public String getId() {
        return this.id;
    }

    public Set<Group<T>> getSubsets() {
        if (this.subsets == null) {
            return null;
        }
        HashSet<Group<T>> result = new HashSet<Group<T>>();
        result.addAll(this.subsets);
        return result;
    }

    public List<Group<T>> getSubsetsAsList() {
        if (this.subsets == null) {
            return null;
        }
        ArrayList<Group<T>> result = new ArrayList<Group<T>>(this.subsets.size());
        result.addAll(this.subsets);
        return result;
    }

    public boolean isRoot() {
        return this.root;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int praefix) {
        StringBuffer result = new StringBuffer();
        this.appendDashes(result, praefix);
        if (praefix > 0) {
            result.append(" ");
        }
        result.append(this.id);
        result.append("\n");
        for (T t : this.elements) {
            this.appendDashes(result, praefix);
            result.append("+ ");
            result.append(t.toString());
            result.append("\n");
        }
        if (this.subsets != null) {
            for (Group group : this.subsets) {
                result.append(group.toString(praefix + 1));
                result.append("\n");
            }
        }
        return result.toString();
    }
}

