% Generated by roxygen2 (4.0.1): do not edit by hand
\name{ie_organizations}
\alias{ie_organizations}
\title{Organization aggregates: Search for contributions to politicians.}
\usage{
ie_organizations(method = NULL, entity_id = NULL, cycle = NULL,
  limit = NULL, page = NULL, per_page = NULL, return = "table",
  key = getOption("SunlightLabsKey",
  stop("need an API key for Sunlight Labs")), ...)
}
\arguments{
\item{method}{(character) The query string. One of top_org, top_rec, pac_rec, party_breakdown,
level_breakdown, registrants, issues, bills, lobbyists, reg_clients, reg_issues, or reg_bills.
reg_lobbyists, reg_text, regulations_submitter, faca, fec_summary, .}

\item{entity_id}{(character) The transparencydata ID to look up.}

\item{cycle}{(character) Filter results to a particular type of entity. One of politician,
organization, individual or industry.}

\item{limit}{(integer) Limit number of records returned.}

\item{page}{The page of results to return; defaults to 1.}

\item{per_page}{The number of results to return per page, defaults to 1,000.
The maximum number of records per page is 100,000.}

\item{key}{your SunlightLabs API key; loads from .Rprofile}

\item{...}{Optional additional curl options (debugging tools mostly)}

\item{return}{(character) One of table (default), list, or response (httr response object).
When table is requested, the default, a table is not always returned, but is returned almost
always. You can then make a table yourself if you like.}
}
\value{
A list. Depends on parameters used. Ranges from a single ID returned to basic
information about the the contributions to and from each entity.
}
\description{
Organization aggregates: Search for contributions to politicians.
}
\examples{
\dontrun{
# Top Organizations
ie_organizations(method='top_org', limit=1)

# Top Recipients
ie_organizations(method='top_rec', entity_id='1b8fea7e453d4e75841eac48ff9df550', limit=2)

# PAC Recipients
ie_organizations(method='pac_rec', entity_id='1b8fea7e453d4e75841eac48ff9df550', cycle=2002)

# Party Breakdown
ie_organizations(method='party_breakdown', entity_id='1b8fea7e453d4e75841eac48ff9df550')

# State/Federal (Level) Breakdown
ie_organizations(method='level_breakdown', entity_id='1b8fea7e453d4e75841eac48ff9df550')

# Lobbing Registrants
ie_organizations(method='registrants', entity_id='9070ecd132f44963a369479e91950283')

# Lobbying Issues
ie_organizations(method='issues', entity_id='9070ecd132f44963a369479e91950283', limit=3)

# Bills
ie_organizations(method='bills', entity_id='9070ecd132f44963a369479e91950283')

# Lobbyists
ie_organizations(method='lobbyists', entity_id='9070ecd132f44963a369479e91950283')

# Registrant Clients
ie_organizations(method='reg_clients', entity_id='52a1620b2ff543ebb74718fbff742529')

# Registrant Issues
ie_organizations(method='reg_issues', entity_id='52a1620b2ff543ebb74718fbff742529')

# Registrant Bills
ie_organizations(method='reg_bills', entity_id='52a1620b2ff543ebb74718fbff742529')

# Registrant Lobbyists
ie_organizations(method='reg_lobbyists', entity_id='52a1620b2ff543ebb74718fbff742529')

# Mentions in Regulations
ie_organizations(method='reg_text', entity_id='721c64757c11435393edc49bb33d4c96')

# Regulatory Comment Submissions
ie_organizations(method='regulations_submitter', entity_id='9070ecd132f44963a369479e91950283')

# FACA Memberships
ie_organizations(method='faca', entity_id='52a1620b2ff543ebb74718fbff742529')

# FEC Summary
ie_organizations(method='fec_summary', entity_id='52a1620b2ff543ebb74718fbff742529')
}
}

