% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cg_votes.R
\name{cg_votes}
\alias{cg_votes}
\title{Search for data on votes.}
\usage{
cg_votes(roll_id = NULL, chamber = NULL, number = NULL, year = NULL,
  congress = NULL, voted_at = NULL, vote_type = NULL, roll_type = NULL,
  required = NULL, result = NULL, bill_id = NULL, nomination_id = NULL,
  query = NULL, fields = NULL, page = 1, per_page = 20, order = NULL,
  key = NULL, as = "table", callopts = list(), ...)
}
\arguments{
\item{roll_id}{A unique identifier for a roll call vote. Made from the first letter of the
chamber, the vote number, and the legislative year.}

\item{chamber}{The chamber the vote was taken in. 'house' or 'senate'}

\item{number}{The number that vote was assigned. Numbers reset every legislative year.}

\item{year}{The 'legislative year' of the vote. This is not quite the same as the calendar year
- the legislative year changes at noon EST on January 3rd. A vote taken on January 1, 2013 has
a 'legislative year' of 2012.}

\item{congress}{The Congress this vote was taken in.}

\item{voted_at}{The time the vote was taken.}

\item{vote_type}{The type of vote being taken. This classification is imperfect and unofficial,
and may change as we improve our detection. Valid types are 'passage', 'cloture', 'nomination',
'impeachment', 'treaty', 'recommit', 'quorum', 'leadership', and 'other'.}

\item{roll_type}{The official description of the type of vote being taken.}

\item{required}{The required ratio of Aye votes necessary to pass the legislation. A value of
'1/2' actually means more than 1/2. Ties are not possible in the Senate (the Vice President
casts a tie-breaker vote), and in the House, a tie vote means the vote does not pass.}

\item{result}{The official result of the vote. This is not completely standardized (both
'Passed' and 'Bill Passed' may appear). In the case of a vote for Speaker of the House, the
result field contains the name of the victor.}

\item{bill_id}{If a vote is related to a bill, the bill's ID.}

\item{nomination_id}{If a vote is related to a nomination, the nomination's ID.}

\item{query}{(character) Return results the API thinks best match your query. Queries are
interpreted as phrases.}

\item{fields}{You can request specific fields by supplying a vector of fields names. Many fields
are not returned unless requested. If you don't supply a fields parameter, you will get the
most commonly used subset of fields only. To save on bandwidth, parsing time, and confusion,
it's recommended to always specify which fields you will be using.}

\item{page}{Page to return. Default: 1. You can use this in combination with the
per_page parameter to get more than the default or max number of results per page.}

\item{per_page}{Number of records to return. Default: 20. Max: 50.}

\item{order}{Sort results by one or more fields with the order parameter. order is
optional, but if no order is provided, the order of results is not guaranteed to be predictable.
Append \code{__asc} or \code{__desc} to the field names to control sort direction. The default
direction is \code{desc}, because it is expected most queries will sort by a date. Any field
which can be used for filtering may be used for sorting. On full-text search endpoints (URLs
ending in \code{/search}), you may sort by score to order by relevancy.}

\item{key}{your SunlightLabs API key; loads from .Rprofile}

\item{as}{(character) One of table (default), list, or response (httr response object)}

\item{callopts}{Curl options to be passed on to httr::GET}

\item{...}{See Details. You can pass on additional parameters.}
}
\description{
Search for data on votes.
}
\details{
Two parameters can be passed on that vary with vote and/or party plus vote:
\itemize{
 \item breakdown.total.[vote] The number of members who cast [vote], where [vote] is a valid
 vote as defined above.
 \item breakdown.party.[party].[vote] The number of members of [party] who cast [vote],
 where [party] is one of 'D', 'R', or 'I', and [vote] is a valid vote as defined above.
}
}
\examples{
\dontrun{
cg_votes(chamber='senate', order='voted_at')
cg_votes(query='guns')
cg_votes(voter_ids.A000055__exists=TRUE)

# Pass in more than one value for a parameter
cg_votes(chamber = c('house', 'senate'))
}
}

