% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{set_rsyntax_threads}
\alias{set_rsyntax_threads}
\title{Set number of threads to be used by rsyntax functions}
\usage{
set_rsyntax_threads(threads = NULL)
}
\arguments{
\item{threads}{The number of threads to use. Cannot be higher than number of threads used by data.table, which you can change with \code{\link[data.table]{setDTthreads}}. If left empty (NULL), all data.table threads are used}
}
\value{
Does not return a value. Sets the global 'rsyntax_threads' option.
}
\description{
rsyntax relies heavily on the data.table package, which supports multithreading. 
By default, the number of threads set by data.table are used, as you can see with \code{\link[data.table]{getDTthreads}}.
Here you can set the number of threads for rsyntax functions, without affecting the data.table settings.
}
\examples{
current_threads = rsyntax_threads()

set_rsyntax_threads(2)

## undo change (necessary for CRAN checks)
set_rsyntax_threads(current_threads)
}
