% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rt_ticket_attachment_content.R
\name{rt_ticket_attachment_content}
\alias{rt_ticket_attachment_content}
\title{Get the content of an attachment}
\usage{
rt_ticket_attachment_content(ticket_id, attachment_id, ...)
}
\arguments{
\item{ticket_id}{(numeric) The ticket identifier}

\item{attachment_id}{(numeric) The attachment identifier}

\item{...}{Other arguments passed to \code{\link{rt_GET}}}
}
\value{
(rt_api) An \code{rt_api} object with the response
}
\description{
Gets the content of the specified attachment for further processing or
manipulation. You'll almost always want to call a second function like
\code{\link[httr]{content}} to make the content of the
attachment usable from R.
}
\examples{
\dontrun{
# First, get the attachment content which gives is the raw response
att <- rt_ticket_attachment_content(2, 1)

# Then process it directly in R
httr::content(att)

# Or write it to disk
out_path <- tempfile()
writeBin(httr::content(x, as = 'raw'), out_path)
}
}
