% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argument_conventions.R
\name{lyt_args}
\alias{lyt_args}
\title{Layouting Function Arg Conventions}
\usage{
lyt_args(
  lyt,
  var,
  vars,
  label,
  labels_var,
  varlabels,
  varnames,
  split_format,
  nested,
  format,
  cfun,
  cformat,
  split_fun,
  split_name,
  split_label,
  afun,
  inclNAs,
  valorder,
  ref_group,
  compfun,
  label_fstr,
  child_labels,
  extra_args,
  name,
  cuts,
  cutlabels,
  cutfun,
  cutlabelfun,
  cumulative,
  indent_mod,
  show_labels,
  label_pos,
  var_labels,
  cvar,
  table_names,
  topleft
)
}
\arguments{
\item{lyt}{layout object pre-data used for tabulation}

\item{var}{string, variable name}

\item{vars}{character vector. Multiple variable names.}

\item{label}{character(1). A label (not to be confused with the name) for the object/structure.}

\item{labels_var}{string, name of variable containing labels to be displayed for the values of \code{var}}

\item{varlabels}{character vector. Labels for \code{vars}}

\item{varnames}{character vector. Names for \code{vars} which will appear in pathing. When \code{vars} are all unique this will be the variable names. If not, these will be variable names with suffixes as necessary to enforce uniqueness.}

\item{split_format}{FormatSpec. Default format associated with the split being created.}

\item{nested}{boolean, Add this as a new top-level split  (defining a new subtable directly under root). Defaults to \code{FALSE}}

\item{format}{FormatSpec. Format associated with this split. Formats can be declared via strings (\code{"xx.x"}) or function. In cases such as \code{analyze} calls, they can character vectors or lists of functions.}

\item{cfun}{list/function/NULL. tabulation function(s) for creating content rows. Must accept \code{x} or \code{df} as first parameter. Must accept \code{labelstr} as the second argument. Can optionally accept all optional arguments accepted by analysis functions. See \code{\link{analyze}}.}

\item{cformat}{format spec. Format for content rows}

\item{split_fun}{function/NULL. custom splitting function See \code{\link{custom_split_funs}}}

\item{split_name}{string. Name associiated with this split (for pathing, etc)}

\item{split_label}{string. Label string to be associated with the table generated by the split. Not to be confused with labels assigned to each child (which are based on the data and type of split during tabulation).}

\item{afun}{function. Analysis function, must take \code{x} or \code{df} as its first parameter. Can optionally take other parameters which will be populated by the tabulation framework. See Details in \code{\link{analyze}}.}

\item{inclNAs}{boolean. Should observations with NA in the \code{var} variable(s) be included when performing this analysis. Defaults to \code{FALSE}}

\item{valorder}{character vector. Order that the split children should appear in resulting table.}

\item{ref_group}{character. Value of \code{var} to be taken as the ref_group/control to be compared against.}

\item{compfun}{function/string. The comparison function which accepts the analysis function outputs for two different partitions and returns a single value. Defaults to subraction. If a string, taken as the name of a function.}

\item{label_fstr}{string. An sprintf style format string containing. For non-comparison splits, it can contain  up to one \code{"\%s"} which takes the current split value and generates the row/column label. Comparison-based splits it can contain up to two \code{"\%s"}.}

\item{child_labels}{string. One of \code{"default"}, \code{"visible"}, \code{"hidden"}. What should the display behavior be for the  labels (ie label rows) of the children of this split. Defaults to \code{"default"} which flags the label row as visible only if the child has 0 content rows.}

\item{extra_args}{list. Extra arguments to be passed to the tabulation function. Element position in thte list corresponds to the children of this split. Named elements in the child-specific lists are ignored if they do not match a formal argument of the ttabulation function.}

\item{name}{character(1). Name of the split/table/row being creatted. Defaults to same as the corresponding llabel, but is not required to be.}

\item{cuts}{numeric. Cuts to use}

\item{cutlabels}{character (or NULL). Labels for the cuts}

\item{cutfun}{function. Function which accepts the \emph{full vector} of \code{var} values and returns cut points to be used (via \code{cut}) when splitting data during tabulation}

\item{cutlabelfun}{function. Function which returns either labels for the cuts or NULL when passed the return value of \code{cutfun}}

\item{cumulative}{logical. Should the cuts be treated as cumulative. Defaults to \code{FALSE}}

\item{indent_mod}{numeric. Modifier for the default indent position for the structure created by this function(subtable, content table, or row) \emph{and all of that structure's children}. Defaults to 0, which corresponds to the unmodified default behavior.}

\item{show_labels}{character(1). Should the variable labels for corresponding to the variable(s) in \code{vars} be visible in the resulting table.}

\item{label_pos}{character(1). Location the variable label should be displayed, Accepts  hidden (default for non-analyze row splits), visible, topleft, and - for analyze splits only - default.  For analyze calls, \code{default} indicates that the variable
should be visible if and only if multiple variables are analyzed at the same level of nesting.}

\item{var_labels}{character. Variable labels for 1 or more variables}

\item{cvar}{character(1). The variable, if any, which the content function should accept. Defaults to NA.}

\item{table_names}{character. Names for the tables representing each atomic analysis. Defaults to \code{var}.}

\item{topleft}{character. Override values for the "top left" material to be displayed during printing.}
}
\value{
NULL (this is an argument template dummy function)
}
\description{
Layouting Function Arg Conventions
}
\seealso{
Other conventions: 
\code{\link{compat_args}()},
\code{\link{constr_args}()},
\code{\link{gen_args}()},
\code{\link{sf_args}()}
}
\concept{conventions}
