% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jss_article.R
\name{jss_article}
\alias{jss_article}
\title{Journal of Statistical Software (JSS) format.}
\usage{
jss_article(..., keep_tex = TRUE, citation_package = "natbib")
}
\arguments{
\item{...}{Arguments to \code{rmarkdown::pdf_document}}

\item{keep_tex}{Keep the intermediate tex file used in the conversion to PDF}

\item{citation_package}{The LaTeX package to process citations, \code{natbib}
or \code{biblatex}. Use \code{none} if neither package is to be used.}
}
\value{
R Markdown output format to pass to
  \code{\link[rmarkdown:render]{render}}
}
\description{
Format for creating a Journal of Statistical Software (JSS) articles. Adapted
from
\href{http://www.jstatsoft.org/about/submissions}{http://www.jstatsoft.org/about/submissions}.
}
\examples{

\dontrun{
library(rmarkdown)
draft("MyArticle.Rmd", template = "jss_article", package = "rticles")
}

}
