% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_raster.R
\name{ts_raster}
\alias{ts_raster}
\title{Assemble/interpolate a raster time series}
\usage{
ts_raster(
  r_list,
  r_times,
  out_times = NA,
  fade_raster = FALSE,
  ...,
  verbose = TRUE
)
}
\arguments{
\item{r_list}{a list of raster objects.}

\item{r_times}{POSIXct, a vector of times corresponding to the elements of \code{r_list}.}

\item{out_times}{POSIXct, a vector of times for which output rasters will be created.}

\item{fade_raster}{(Optional) logical. If \code{TRUE} performs a linear interpolation to calculate the values for the output raster. Otherwise uses a nearest temporal neighbor approach. Default is \code{FALSE}.}

\item{...}{additional arguments.}

\item{verbose}{(Optional) logical. If \code{TRUE} outputs progress. Default is \code{TRUE}.}
}
\value{
a list of raster objects.
}
\description{
This function assembles a raster time series by assigning or interpolating input rasters to a target time series.
}
\examples{
#Setup

 library(rtsVis)
 # Load example dataset at a greatly increased interval
x_list <- MODIS_SI_ds[seq(1,length(MODIS_SI_ds),30)]
x_dates <- do.call(c, lapply(MODIS_SI_ds,attr,"time") )[seq(1,length(MODIS_SI_ds),30)]

#Fill NAs
x_list_filled <- ts_fill_na(x_list)

#Make a sequence of output dates, double the length of input dates
out_dates <-seq.POSIXt(from = x_dates[1],
                       to = x_dates[length(x_dates)],length.out = length(x_dates)*2 )

#For each output date, interpolate a raster image from the input files
r_list_out <- ts_raster(r_list = x_list_filled,
                        r_times = x_dates,
                        out_times = out_dates,
                        fade_raster = TRUE)
}
\author{
Jakob Schwalb-Willmann, Johannes Mast
}
