% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-CramerLundberg.R
\docType{methods}
\name{simulate_path,CramerLundberg-method}
\alias{simulate_path,CramerLundberg-method}
\title{Simulates a path of a Cramer-Lundberg model}
\usage{
\S4method{simulate_path}{CramerLundberg}(model, max_time_horizon = NULL,
  max_simulation_time = NULL, seed = NULL)
}
\arguments{
\item{model}{an S4 object of \linkS4class{CramerLundberg} class.}

\item{max_time_horizon}{a length one numeric vector specifying the maximum
time horizon, until with the process will be simulated. Default: \code{Inf}.}

\item{max_simulation_time}{a length one numeric vector indicating the maximum
allowed time of simulation. The value should be specified in seconds.
Default: \code{Inf}.}

\item{seed}{an optional arbitrary length numeric vector specifying the seed.
If provided, the \code{.Random.seed} in \code{.GlobalEnv} is set to its
value.}
}
\value{
\linkS4class{PathCramerLundberg}
}
\description{
\code{simulate_path()} simulates a path of \linkS4class{CramerLundberg}
model until one of the following conditions is met: (1) the process is
ruined, (2) \code{max_time_horizon} is achieved, (3) the elapsed time of the
simulation is greater than \code{max_simulation_time}.
}
\section{Warning}{

Setting both \code{max_time_horizon} and \code{max_simulation_time} to
\code{Inf} might be dangerous. In this case, the only stopping condition is a
ruin of the process, which might not happen.
}

\examples{
model <- CramerLundberg(initial_capital = 10,
                        premium_rate = 1,
                        claim_poisson_arrival_rate = 1,
                        claim_size_generator = rexp,
                        claim_size_parameters = list(rate = 1))

path <- simulate_path(model = model, max_time_horizon = 10)
}
