% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoencoder_contractive.R
\name{autoencoder_contractive}
\alias{autoencoder_contractive}
\title{Create a contractive autoencoder}
\usage{
autoencoder_contractive(network, loss = "mean_squared_error",
  weight = 2e-04)
}
\arguments{
\item{network}{Layer construct of class \code{"ruta_network"}}

\item{loss}{Character string specifying the reconstruction error part of the loss function}

\item{weight}{Weight assigned to the contractive loss}
}
\value{
A construct of class \code{"ruta_autoencoder"}
}
\description{
A contractive autoencoder adds a penalty term to the loss
function of a basic autoencoder which attempts to induce a contraction of
data in the latent space.
}
\references{
\itemize{
\item \href{https://arxiv.org/abs/1801.01586}{A practical tutorial on autoencoders for nonlinear feature fusion}
}
}
\seealso{
Other autoencoder variants: \code{\link{autoencoder_denoising}},
  \code{\link{autoencoder_robust}},
  \code{\link{autoencoder_sparse}},
  \code{\link{autoencoder_variational}},
  \code{\link{autoencoder}}
}
\concept{autoencoder variants}
