% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rep_rv.R
\name{rep.rv}
\alias{rep.rv}
\title{Replicate Elements of Random Vectors}
\usage{
\method{rep}{rv}(x, times, ...)
}
\arguments{
\item{x}{a random vector to be replicated}

\item{times}{number of replications}

\item{\dots}{further arguments passed to \code{rep}}
}
\description{
Transpose a random array by permuting its dimensions and optionally resizing
it.
}
\details{
This is the rv-compatible version of the function \code{\link{rep}}.

Since \code{rep} is not a generic function, the whole name \code{rep.rv}
must be specified when calling the function when \code{x} is an 'rv' object.
}
\examples{

  print(rep(rvnorm(1), times=4))

}
\references{
Kerman, J. and Gelman, A. (2007). Manipulating and Summarizing
Posterior Simulations Using Random Variable Objects. Statistics and
Computing 17:3, 235-244.

See also \code{vignette("rv")}.
}
\seealso{
\code{\link{rep}}
}
\author{
Jouni Kerman \email{jouni@kerman.com}
}
\keyword{manip}
