% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getters.R
\name{getters}
\alias{getters}
\alias{get_structure}
\alias{get_pair_copula}
\alias{get_all_pair_copulas}
\alias{get_parameters}
\alias{get_all_parameters}
\alias{get_ktau}
\alias{get_all_ktaus}
\alias{get_matrix}
\alias{get_family}
\alias{get_all_families}
\title{Extracts components of \code{bicop_dist} and \code{vinecop_dist} objects}
\usage{
get_structure(object)

get_pair_copula(object, tree = NA, edge = NA)

get_parameters(object, tree = NA, edge = NA)

get_ktau(object, tree = NA, edge = NA)

get_family(object, tree = NA, edge = NA)

get_all_pair_copulas(object, trees = NA)

get_all_parameters(object, trees = NA)

get_all_ktaus(object, trees = NA)

get_all_families(object, trees = NA)
}
\arguments{
\item{object}{a \code{bicop_dist}, \code{vinecop_dist} or \code{vine_dist} object.}

\item{tree}{tree index (not required if \code{object} is of class \code{bicop_dist}).}

\item{edge}{edge index (not required if \code{object} is of class \code{bicop_dist}).}

\item{trees}{the trees to extract from \code{object} (\code{trees = NA} extracts all
trees).}
}
\value{
The structure matrix, or pair-copulas, their parameters, Kendall's taus,
or families.
}
\description{
Extracts either the structure matrix  (for \code{vinecop_dist} only), or
pair-copulas, their parameters, Kendall's taus, or families
(for \code{bicop_dist} and \code{vinecop_dist}).
}
\details{
#' The \link{get_structure} method (for \code{vinecop_dist} or \code{vine_dist} objects only)
extracts the structure (see \link{rvine_structure} for more details).

The \link{get_matrix} method (for \code{vinecop_dist} or \code{vine_dist} objects only)
extracts the structure matrix (see \link{rvine_structure} for more details).

The other \code{get_xyz} methods for \code{vinecop_dist} or \code{vine_dist} objects return
the entries corresponding to the pair-copula indexed by its \code{tree} and \code{edge}.
When \code{object} is of class \code{bicop_dist}, \code{tree} and \code{edge} are not required. \cr

\link{get_pair_copula} = the pair-copula itself (see \link{bicop}).\cr
\link{get_parameters} = the parameters of the pair-copula (i.e., a \code{numeric}
scalar, vector, or matrix).\cr
\link{get_family} = a character for the family (see \link{bicop} for implemented families).\cr
\link{get_ktau} = a \code{numeric} scalar with the pair-copula Kendall's tau.\cr

The \code{get_all_xyz} methods (for \code{vinecop_dist} or \code{vine_dist} objects only)
return lists of lists, with each element corresponding to a tree in \code{trees},
and then elements of the sublists correspond to edges.
The returned lists have two additional attributes: \cr

\code{"d"} = the dimension of the model.\cr
\code{"trees"} = the extracted trees.\cr
}
\examples{
# specify pair-copulas
bicop <- bicop_dist("bb1", 90, c(3, 2))
pcs <- list(
  list(bicop, bicop), # pair-copulas in first tree
  list(bicop) # pair-copulas in second tree
)

# specify R-vine matrix
mat <- matrix(c(1, 2, 3, 1, 2, 0, 1, 0, 0), 3, 3)

# set up vine copula model
vc <- vinecop_dist(pcs, mat)

# get the structure
get_structure(vc)
all.equal(get_matrix(vc), mat, check.attributes = FALSE)

# get pair-copulas
get_pair_copula(vc, 1, 1)
get_all_pair_copulas(vc)
all.equal(get_all_pair_copulas(vc), pcs, check.attributes = FALSE)
}
