% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RPSS.R
\name{RPSS}
\alias{RPSS}
\title{Compute the Ranked Probability Skill Score}
\usage{
RPSS(
  exp,
  obs,
  ref = NULL,
  time_dim = "sdate",
  memb_dim = "member",
  prob_thresholds = c(1/3, 2/3),
  indices_for_clim = NULL,
  Fair = FALSE,
  weights = NULL,
  ncores = NULL
)
}
\arguments{
\item{exp}{A named numerical array of the forecast with at least time 
dimension.}

\item{obs}{A named numerical array of the observation with at least time 
dimension. The dimensions must be the same as 'exp' except 'memb_dim'.}

\item{ref}{A named numerical array of the reference forecast data with at 
least time dimension. The dimensions must be the same as 'exp' except 
'memb_dim'. If it is NULL, the climatological forecast is used as reference
forecast. The default value is NULL.}

\item{time_dim}{A character string indicating the name of the time dimension.
The default value is 'sdate'.}

\item{memb_dim}{A character string indicating the name of the member dimension
to compute the probabilities of the forecast and the reference forecast. The
default value is 'member'.}

\item{prob_thresholds}{A numeric vector of the relative thresholds (from 0 to
1) between the categories. The default value is c(1/3, 2/3), which 
corresponds to tercile equiprobable categories.}

\item{indices_for_clim}{A vector of the indices to be taken along 'time_dim' 
for computing the thresholds between the probabilistic categories. If NULL,
the whole period is used. The default value is NULL.}

\item{Fair}{A logical indicating whether to compute the FairRPSS (the 
potential RPSS that the forecast would have with an infinite ensemble size).
The default value is FALSE.}

\item{weights}{A named two-dimensional numerical array of the weights for each
member and time. The dimension names should include 'memb_dim' and 
'time_dim'. The default value is NULL. The ensemble should have at least 70 
members or span at least 10 time steps and have more than 45 members if 
consistency between the weighted and unweighted methodologies is desired.}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL.}
}
\value{
\item{$rpss}{
 A numerical array of the RPSS with the same dimensions as "exp" except the
 'time_dim' and 'memb_dim' dimensions.
}
\item{$sign}{
 A logical array of the statistical significance of the RPSS with the same
 dimensions as 'exp' except the 'time_dim' and 'memb_dim' dimensions.
}
}
\description{
The Ranked Probability Skill Score (RPSS; Wilks, 2011) is the skill score 
based on the Ranked Probability Score (RPS; Wilks, 2011). It can be used to 
assess whether a forecast presents an improvement or worsening with respect to
a reference forecast. The RPSS ranges between minus infinite and 1. If the 
RPSS is positive, it indicates that the forecast has higher skill than the 
reference forecast, while a negative value means that it has a lower skill. 
Examples of reference forecasts are the climatological forecast (same 
probabilities for all categories for all time steps), persistence, a previous
model version, and another model. It is computed as RPSS = 1 - RPS_exp / RPS_ref.
The statistical significance is obtained based on a Random Walk test at the 
95% confidence level (DelSole and Tippett, 2016).
}
\examples{
exp <- array(rnorm(1000), dim = c(lat = 3, lon = 2, member = 10, sdate = 50))
obs <- array(rnorm(1000), dim = c(lat = 3, lon = 2, sdate = 50))
ref <- array(rnorm(1000), dim = c(lat = 3, lon = 2, member = 10, sdate = 50))
res <- RPSS(exp = exp, obs = obs) ## climatology as reference forecast
res <- RPSS(exp = exp, obs = obs, ref = ref) ## ref as reference forecast

}
\references{
Wilks, 2011; https://doi.org/10.1016/B978-0-12-385022-5.00008-7
DelSole and Tippett, 2016; https://doi.org/10.1175/MWR-D-15-0218.1
}
