% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotACC.R
\name{PlotACC}
\alias{PlotACC}
\title{Plot Plumes/Timeseries Of Anomaly Correlation Coefficients}
\usage{
PlotACC(
  ACC,
  sdates,
  toptitle = "",
  sizetit = 1,
  ytitle = "",
  limits = NULL,
  legends = NULL,
  freq = 12,
  biglab = FALSE,
  fill = FALSE,
  linezero = FALSE,
  points = TRUE,
  vlines = NULL,
  fileout = NULL,
  width = 8,
  height = 5,
  size_units = "in",
  res = 100,
  ...
)
}
\arguments{
\item{ACC}{An ACC array with with dimensions:\cr
c(nexp, nobs, nsdates, nltime, 4)\cr
with the fourth dimension of length 4 containing the lower limit of the 
95\% confidence interval, the ACC, the upper limit of the 95\% confidence 
interval and the 95\% significance level.}

\item{sdates}{A character vector of startdates: c('YYYYMMDD','YYYYMMDD').}

\item{toptitle}{A character string of the main title, optional.}

\item{sizetit}{A multiplicative factor to scale title size, optional.}

\item{ytitle}{A character string of the title of Y-axis for each experiment:
c('', ''), optional.}

\item{limits}{A numeric vector c(lower limit, upper limit): limits of the 
Y-axis, optional.}

\item{legends}{A character vector of flags to be written in the legend, 
optional.}

\item{freq}{A integer: 1 = yearly, 12 = monthly, 4 = seasonal, ... Default: 12.}

\item{biglab}{A logical value for presentation/paper plot, Default = FALSE.}

\item{fill}{A logical value if filled confidence interval. Default = FALSE.}

\item{linezero}{A logical value if a line at y=0 should be added. Default = FALSE.}

\item{points}{A logical value if points instead of lines. Default = TRUE.\cr
Must be TRUE if only 1 leadtime.}

\item{vlines}{A vector of x location where to add vertical black lines, optional.}

\item{fileout}{A character string of the output file name. Extensions allowed: 
eps/ps, jpeg, png, pdf, bmp and tiff. Default is NULL.}

\item{width}{A numeric of the file width, in the units specified in the 
parameter size_units (inches by default). Takes 8 by default.}

\item{height}{A numeric of the file height, in the units specified in the parameter 
size_units (inches by default). Takes 5 by default.}

\item{size_units}{A character string of the units of the size of the device 
(file or window) to plot in. Inches ('in') by default. See ?Devices and the 
creator function of the corresponding device.}

\item{res}{Resolution of the device (file or window) to plot in. See 
?Devices and the creator function of the corresponding device.}

\item{\dots}{Arguments to be passed to the method. Only accepts the following
graphical parameters:\cr
adj ann ask bg bty cex.sub cin col.axis col.lab col.main col.sub cra crt 
csi cxy err family fg fig fin font font.axis font.lab font.main font.sub 
lend lheight ljoin lmitre mar mex mfcol mfrow mfg mkh oma omd omi page 
plt smo srt tck tcl usr xaxp xaxs xaxt xlog xpd yaxp yaxs yaxt ylbias ylog\cr
For more information about the parameters see `par`.}
}
\description{
Plots plumes/timeseries of ACC from an array with dimensions 
(output from \code{ACC()}): \cr
c(nexp, nobs, nsdates, nltime, 4)\cr
where the fourth dimension is of length 4 and contains the lower limit of 
the 95\% confidence interval, the ACC, the upper limit of the 95\% 
confidence interval and the 95\% significance level given by a one-sided 
T-test.
}
\examples{
 \dontshow{
startDates <- c('19851101', '19901101', '19951101', '20001101', '20051101')
sampleData <- s2dv:::.LoadSampleData('tos', c('experiment'),
                                               c('observation'), startDates,
                                               leadtimemin = 1,
                                               leadtimemax = 4,
                                               output = 'lonlat',
                                               latmin = 27, latmax = 48,
                                               lonmin = -12, lonmax = 40)
 }
sampleData$mod <- Season(sampleData$mod, monini = 11, moninf = 12, monsup = 2)
sampleData$obs <- Season(sampleData$obs, monini = 11, moninf = 12, monsup = 2) 
clim <- Clim(sampleData$mod, sampleData$obs)
ano_exp <- Ano(sampleData$mod, clim$clim_exp)
ano_obs <- Ano(sampleData$obs, clim$clim_obs)
acc <- ACC(ano_exp, ano_obs, lat = sampleData$lat)
acc_bootstrap <- ACC(ano_exp, ano_obs, lat = sampleData$lat, conftype = 'bootstrap')
# Combine acc results for PlotACC
res <- array(c(acc$conf.lower, acc$acc, acc$conf.upper, acc$p.val), 
            dim = c(dim(acc$acc), 4))
res_bootstrap <- array(c(acc$acc_conf.lower, acc$acc, acc$acc_conf.upper, acc$p.val),
                      dim = c(dim(acc$acc), 4))
 \donttest{
PlotACC(res, startDates)
PlotACC(res_bootstrap, startDates)
 }
}
