% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_system.R
\name{touch}
\alias{touch}
\alias{s3_file_touch}
\title{Change file modification time}
\usage{
s3_file_touch(path, ...)
}
\arguments{
\item{path}{(character): A character vector of paths or s3 uri}

\item{...}{parameters to be passed to \code{\link[paws.storage]{s3_copy_object}}}
}
\value{
character vector of s3 uri paths
}
\description{
Similar to \code{fs::file_touch} this does not create the file if
it does not exist. Use \code{s3fs$file_create()} to do this if needed.
}
\note{
This method will only update the modification time of the AWS S3 object.
}
\examples{
\dontrun{
# Require AWS S3 credentials

dir = s3_file_temp(tmp_dir = "MyBucket")
path = s3_path(dir, letters[1:2], ext = "txt")

s3_file_touch(path)
}
}
