% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_system_async.R
\name{copy_async}
\alias{copy_async}
\alias{s3_file_copy_async}
\alias{s3_dir_copy_async}
\title{Copy files and directories}
\usage{
s3_file_copy_async(
  path,
  new_path,
  max_batch = fs_bytes("100MB"),
  overwrite = FALSE,
  ...
)

s3_dir_copy_async(
  path,
  new_path,
  max_batch = fs_bytes("100MB"),
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{path}{(character): path to a local directory of file or a uri.}

\item{new_path}{(character): path to a local directory of file or a uri.}

\item{max_batch}{(\link[fs]{fs_bytes}): Maximum batch size being uploaded with each multipart.}

\item{overwrite}{(logical): Overwrite files if the exist. If this is \code{FALSE}
and the file exists an error will be thrown.}

\item{...}{parameters to be passed to \code{\link[paws.storage]{s3_put_object}}}
}
\value{
return \code{\link[future]{future}} object of \code{\link[=s3_file_copy]{s3_file_copy()}}, \code{\link[=s3_dir_copy]{s3_dir_copy()}}
}
\description{
\code{s3_file_copy} copies files

\code{s3_dir_copy} copies the directory recursively to the new location
}
\seealso{
\code{\link[future]{future}} \code{\link[=s3_file_copy]{s3_file_copy()}} \code{\link[=s3_dir_copy]{s3_dir_copy()}}
}
