% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/upsilon.r
\name{upsilon}
\alias{dupsilon}
\alias{pupsilon}
\alias{qupsilon}
\alias{rupsilon}
\alias{upsilon}
\title{The upsilon distribution.}
\usage{
dupsilon(x, df, t, log = FALSE, order.max=6)

pupsilon(q, df, t, lower.tail = TRUE, log.p = FALSE, order.max=6)

qupsilon(p, df, t, lower.tail = TRUE, log.p = FALSE, order.max=6)

rupsilon(n, df, t)
}
\arguments{
\item{x,q}{vector of quantiles.}

\item{df}{the degrees of freedom in the chi square. a vector. we do
\emph{not} vectorize over this variable.}

\item{t}{the scaling parameter on the chi. a vector. should be the same
length as \code{df}. we do \emph{not} vectorize over this variable.}

\item{log}{logical; if TRUE, densities \eqn{f} are given
as \eqn{\mbox{log}(f)}{log(f)}.}

\item{order.max}{the order to use in the approximate density,
distribution, and quantile computations, via the Gram-Charlier,
Edeworth, or Cornish-Fisher expansion.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}

\item{log.p}{logical; if TRUE, probabilities p are given
as \eqn{\mbox{log}(p)}{log(p)}.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
 \eqn{P[X \le x]}{P[X <= x]}, otherwise, \eqn{P[X > x]}{P[X > x]}.}
}
\value{
\code{dupsilon} gives the density, \code{pupsilon} gives the
distribution function, \code{qupsilon} gives the quantile function,
and \code{rupsilon} generates random deviates.

Invalid arguments will result in return value \code{NaN} with a warning.
}
\description{
Density, distribution function, quantile function and random
generation for the upsilon distribution.
}
\details{
Suppose \eqn{x_i \sim \chi^2\left(\nu_i\right)}{x_i ~ X^2(v_i)}
independently and independently of \eqn{Z}{Z}, a standard normal.
Then
\deqn{\Upsilon = Z + \sum_i t_i \sqrt{x_i/\nu_i}}{Y = Z + sum_i t_i sqrt(x_i/v_i)}
takes an upsilon distribution with parameter vectors
\eqn{[\nu_1, \nu_2, \ldots, \nu_k]', [t_1, t_2, ..., t_k]'}{<v_1, v_2, ..., v_k>, <t_1, t_2, ..., t_k>}.

The upsilon distribution is used in certain tests of
the Sharpe ratio for independent observations, and generalizes
the lambda prime distribution, which can be written as
\eqn{Z + t \sqrt{x/\nu}}{Z + t sqrt(x/v)}.
}
\note{
the PDF and CDF are approximated by an Edgeworth expansion; the
quantile function is approximated by a Cornish-Fisher expansion.

The PDF, CDF, and quantile function are approximated, via
the Edgeworth or Cornish Fisher approximations, which may
not be terribly accurate in the tails of the distribution.
You are warned.

The distribution parameters are \emph{not} recycled
with respect to the \code{x, p, q} or \code{n} parameters,
for, respectively, the density, distribution, quantile
and generation functions. This is for simplicity of
implementation and performance. It is, however, in contrast
to the usual R idiom for dpqr functions.
}
\examples{
mydf <- c(100,30,50)
myt <- c(-1,3,5)
rv <- rupsilon(500, df=mydf, t=myt)
d1 <- dupsilon(rv, df=mydf, t=myt)
\dontrun{
plot(rv,d1)
}
p1 <- pupsilon(rv, df=mydf, t=myt)
# should be nearly uniform:
\dontrun{
plot(ecdf(p1))
}
q1 <- qupsilon(ppoints(length(rv)),df=mydf,t=myt)
\dontrun{
qqplot(x=rv,y=q1)
}
\dontrun{
require(SharpeR)
ope <- 252
n.sim <- 500
n.term <- 3
set.seed(234234)
pp <- replicate(n.sim,{
  # these are population parameters
  a <- rnorm(n.term)
  psi <- 6 * rnorm(length(a)) / sqrt(ope)
  b <- sum(a * psi)
  df <- 100 + ceiling(200 * runif(length(psi)))
  comm <- 1 / sqrt(sum(a^2 / df))
  cdf <- df - 1
  # now independent draws from the SR distribution:
  x <- rsr(length(df), df, zeta=psi, ope=1)
  # now compute a p-value under the true null
  pupsilon(comm * b,df=cdf,t=comm*a*x)
  })
# ought to be uniform:
plot(ecdf(pp))
}
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\references{
Lecoutre, Bruno. "Another look at confidence intervals for the noncentral t distribution."
Journal of Modern Applied Statistical Methods 6, no. 1 (2007): 107--116.
\url{http://www.univ-rouen.fr/LMRS/Persopage/Lecoutre/telechargements/Lecoutre_Another_look-JMSAM2007_6(1).pdf}

Lecoutre, Bruno. "Two useful distributions for Bayesian predictive procedures under normal models."
Journal of Statistical Planning and Inference 79  (1999): 93--105.

Pav, Steven. "Inference on the Sharpe ratio via the upsilon distribution.'
Arxiv (2015).
\url{http://arxiv.org/abs/1505.00829}
}
\seealso{
lambda-prime distribution functions,
\code{\link{dlambdap}, \link{plambdap}, \link{qlambdap}, \link{rlambdap}}.
Sum of chi-squares to power distribution functions,
\code{\link{dsumchisqpow}, \link{psumchisqpow}, \link{qsumchisqpow}, \link{rsumchisqpow}}.
}
\keyword{distribution}

