% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saeFH.mprop.R
\name{saeFH.mprop}
\alias{saeFH.mprop}
\title{EBLUPs based on a Multivariate Fay Herriot model with Additive Logistic Transformation}
\usage{
saeFH.mprop(formula, vardir, MAXITER = 100, PRECISION = 1e-04, L = 1000, data)
}
\arguments{
\item{formula}{an object of class \code{\link[stats]{formula}} that describe the fitted model.}

\item{vardir}{sampling variances of direct estimations. If data is defined, it is a vector containing names of sampling variance columns. If data is not defined, it should be a data frame of sampling variances of direct estimators. The order is \eqn{var1, var2, \dots, var(q-1), cov12, \dots, cov1(q-1), cov23, \dots, cov(q-2)(q-1)}.}

\item{MAXITER}{maximum number of iterations allowed in the Fisher-scoring algorithm, Default: \code{100}.}

\item{PRECISION}{convergence tolerance limit for the Fisher-scoring algorithm, Default: \code{1e-4}.}

\item{L}{number of Monte Carlo iterations in calculating Empirical Best Predictor (EBP), Default: \code{1000}.}

\item{data}{optional data frame containing the variables named in \code{formula} and \code{vardir}.}
}
\value{
The function returns a list with the following objects:
   \item{est}{a list containing data frame of the estimators for each domains.}
     \itemize{
       \item \code{PC} : transformed EBLUP estimators using inverse alr for each category.
       \item \code{EBP} : Empirical Best Predictor using Monte Carlo for each category.
     }
   \item{fit}{a list containing the following objects (model is fitted using REML):}
     \itemize{
       \item \code{convergence} : a logical value equal to \code{TRUE} if Fisher-scoring algorithm converges in less than \code{MAXITER} iterations.
       \item \code{iterations} : number of iterations performed by the Fisher-scoring algorithm.
       \item \code{estcoef} : a data frame that contains the estimated model coefficients, standard errors, t-statistics, and p-values of each coefficient.
       \item \code{refvar} : estimated covariance matrix of random effects.
     }
   \item{components}{a list containing the following objects:}
     \itemize{
       \item \code{random.effects} : data frame containing estimated random effect values of the fitted model for each category.
       \item \code{residuals} : data frame containing residuals of the fitted model for each category.
     }
}
\description{
This function gives the transformed EBLUP and Empirical Best Predictor (EBP) based on a multivariate Fay-Herriot model. This function is used for multinomial compositional data. If data has \eqn{P} as proportion and total of \eqn{q} categories \eqn{(P_{1} + P_{2} + \dots + P_{q} = 1)}, then function should be used to estimate \eqn{{P_{1}, P_{2}, \dots, P_{q-1}}}.
}
\examples{
## Load dataset
data(datasaem)

## If data is defined
Fo = list(Y1 ~ X1,
          Y2 ~ X2,
          Y3 ~ X3)
vardir = c("v1", "v2", "v3", "v12", "v13", "v23")
model.data <- saeFH.mprop(Fo, vardir, data = datasaem)

Fo = list(datasaem$Y1 ~ datasaem$X1,
          datasaem$Y2 ~ datasaem$X2,
          datasaem$Y3 ~ datasaem$X3)
vardir = datasaem[, c("v1", "v2", "v3", "v12", "v13", "v23")]
model <- saeFH.mprop(Fo, vardir)

## See the estimators
model$est

}
