% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlme_methods.R
\name{getVarCov}
\alias{getVarCov}
\alias{getVarCov.NER}
\title{Extract variance-covariance matrix from an 'saeTrafo' object}
\usage{
\method{getVarCov}{NER}(obj, individuals = 1, type = "random.effects", ...)
}
\arguments{
\item{obj}{an object of type 'NER'.}

\item{individuals}{vector of levels of the in-sample domains can be specified
for the types "\code{conditional}" or "\code{marginal}".}

\item{type}{a character that determines the type of variance-covariance
matrix. Types that can be chosen
(i) random-effects variance-covariance matrix ("\code{random.effects}"),
(ii) conditional variance-covariance matrix ("\code{conditional}"),
(iii) marginal variance-covariance matrix ("\code{marginal}"). Defaults to
"\code{random.effects}".}

\item{...}{additional arguments that are not used in this method.}
}
\value{
A variance-covariance matrix or a list of variance-covariance
matrices, if more than one individual is selected. For method
\code{getVarCov.NER}, the dimensions of the matrices are 1 x 1 for type
"\code{random.effects}" and number of in-sample domains x number of
in-sample domains for types "\code{conditional}" and "\code{marginal}".
}
\description{
Method \code{getVarCov.NER} extracts the variance-covariance matrix from a
fitted model of class 'NER'.
}
\details{
The generic function \code{getVarCov} is imported from package
\pkg{nlme} and re-exported to make the S3-methods available, even though the
\pkg{nlme} package itself is not loaded or attached. For default
documentation, see \code{\link[nlme]{getVarCov}}.
}
\examples{
# Example to extract variance-covariance matrix

# Load Data
data("eusilcA_smp")
data("pop_area_size")
data("pop_mean")
data("pop_cov")

# Nested error regression model
NER_model <- NER_Trafo(fixed = eqIncome ~ gender + eqsize + cash +
                       self_empl + unempl_ben + age_ben + surv_ben +
                       sick_ben + dis_ben + rent + fam_allow + house_allow +
                       cap_inv + tax_adj,
                       smp_domains = "district",
                       pop_area_size = pop_area_size,
                       pop_mean = pop_mean, pop_cov = pop_cov,
                       smp_data = eusilcA_smp)

getVarCov(NER_model)
}
\seealso{
\code{\link{NER_Trafo}}, \code{\link[nlme]{getVarCov}}
}
