% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zTest.R
\name{computeMinEsBatchSafeZ}
\alias{computeMinEsBatchSafeZ}
\title{Computes the smallest mean difference that is detectable with chance 1-beta, for the provided
sample size}
\usage{
computeMinEsBatchSafeZ(
  nPlan,
  alpha = 0.05,
  beta = 0.2,
  sigma = 1,
  kappa = sigma,
  alternative = c("two.sided", "greater", "less"),
  testType = c("oneSample", "paired", "twoSample"),
  parameter = NULL,
  maxIter = 10
)
}
\arguments{
\item{nPlan}{optional numeric vector of length at most 2. When provided, it is used to find the safe test
defining parameter phiS. Note that if the purpose is to plan based on nPlan alone, then both meanDiffMin
and beta should be set to NULL.}

\item{alpha}{numeric in (0, 1) that specifies the tolerable type I error control --independent on n-- that the
designed test has to adhere to. Note that it also defines the rejection rule e10 > 1/alpha.}

\item{beta}{numeric in (0, 1) that specifies the tolerable type II error control necessary to calculate both "n"
and "phiS". Note that 1-beta defines the power.}

\item{sigma}{numeric > 0 representing the assumed population standard deviation used for the test.}

\item{kappa}{the true population standard deviation. Default kappa=sigma.}

\item{alternative}{a character string specifying the alternative hypothesis must be one of "two.sided" (default),
"greater" or "less".}

\item{testType}{either one of "oneSample", "paired", "twoSample".}

\item{parameter}{optional test defining parameter. Default set to \code{NULL}.}

\item{maxIter}{maximum number of iterations in the optimisation process for two-sided designs}
}
\value{
numeric > 0 that represents the minimal detectable mean difference
}
\description{
Computes the smallest mean difference that is detectable with chance 1-beta, for the provided
sample size
}
