% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chartRenderer.R
\name{chartRenderer}
\alias{chartRenderer}
\title{Create an interactive graphics widget}
\usage{
chartRenderer(data, debug_js = FALSE, settings = NULL, chart = NULL)
}
\arguments{
\item{data}{A data frame containing the labs data. Data must be structured as one record per study participant per time point per lab measure.}

\item{debug_js}{print settings in javascript before rendering chart. Default: \code{FALSE}.}

\item{settings}{Optional list of settings arguments to be converted to JSON using \code{jsonlite::toJSON(settings, auto_unbox = TRUE, dataframe = "rows", null = "null")}. Default: \code{NULL}.}

\item{chart}{name of the chart to render}
}
\description{
This function creates an nice interactive widget. See the vignettes for more details regarding how to customize charts.
}
\examples{
\dontrun{

## Create Histogram figure using a premade settings list
details_list <- list(
  list(value_col = "TRTP", label = "Treatment"),
  list(value_col = "SEX", label = "Sex"),
  list(value_col = "AGEGR1", label = "Age group")
)


filters_list <- list(
  list(value_col = "TRTA", label = "Treatment"),
  list(value_col = "SEX", label = "Sex"),
  list(value_col = "RACE", label = "RACE"),
  list(value_col = "AGEGR1", label = "Age group")
)

settingsl <- list(id_col = "USUBJID",
      value_col = "AVAL",
      measure_col = "PARAM",
      unit_col = "PARAMCD",
      normal_col_low = "A1LO",
      normal_col_high = "A1HI",
      details = details_list,
      filters = filters_list)

chartRenderer(data=adlbc, settings = settingsl, chart=safetyhistogram)

}

}
