% Generated by roxygen2 (4.0.2): do not edit by hand
\name{ss2s4m}
\alias{ss2s4m}
\title{Sample Sizes in Two-Stage sampling Designs for Estimating Signle Means}
\usage{
ss2s4m(N, mu, sigma, conf = 0.95, rme = 0.03, M, by, rho)
}
\arguments{
\item{N}{The population size.}

\item{mu}{The value of the estimated mean of a variable of interest.}

\item{sigma}{The value of the estimated standard deviation of a variable of interest.}

\item{conf}{The statistical confidence. By default conf = 0.95. By default \code{conf = 0.95}.}

\item{rme}{The maximun relative margin of error that can be allowed for the estimation.}

\item{M}{Number of clusters in the population.}

\item{by}{number: increment of the sequence in the grid.}

\item{rho}{The Intraclass Correlation Coefficient.}
}
\value{
This function returns a grid of possible sample sizes.
The first column represent the design effect,
the second column is the number of clusters to be selected,
the third column is the number of units to be selected inside the clusters,
and finally, the last column indicates the full sample size induced by this particular strategy.
}
\description{
This function computes a grid of possible sample sizes for estimating single means under two-stage sampling designs.
}
\details{
In two-stage (2S) sampling, the design effect is defined by
\deqn{DEFF = 1 + (m-1)\rho}
Where \eqn{\rho} is defined as the intraclass correlation coefficient,
m is the average sample size of units selected inside each cluster.
The relationship of the full sample size of the two stage design (2S) with the
simple random sample (SI) design is given by
\deqn{ n_{2S} =  n_{SI}*DEFF}
}
\examples{
ss2s4m(N=100000, mu=10, sigma=2, conf=0.95, rme=0.03, M=50, by=5, rho=0.01)
ss2s4m(N=100000, mu=10, sigma=2, conf=0.95, rme=0.03, M=50, by=5, rho=0.1)
ss2s4m(N=100000, mu=10, sigma=2, conf=0.95, rme=0.03, M=50, by=5, rho=0.2)
ss2s4m(N=100000, mu=10, sigma=2, conf=0.95, rme=0.05, M=50, by=5, rho=0.3)

##########################################
# Almost same mean in each cluster       #
#                                        #
# - Heterogeneity within clusters        #
# - Homogeinity between clusters         #
#                                        #
#  Decision rule:                        #
#    * Select a lot of units per cluster #
#    * Select a few of clusters          #
##########################################

# Population size
N <- 1000000
# Number of clusters in the population
NI <- 1000
# Number of elements per cluster
N/NI

# The variable of interest
y <- c(1:N)
# The clustering factor
cl <- rep(1:NI, length.out=N)

rho = ICC(y,cl)$ICC
rho

ss2s4m(N, mu=mean(y), sigma=sd(y), conf=0.95, rme=0.03, M=N/NI, by=10, rho)


##########################################
# Very different means per cluster       #
#                                        #
# - Heterogeneity between clusters       #
# - Homogeinity within clusters          #
#                                        #
#  Decision rule:                        #
#    * Select a few of units per cluster #
#    * Select a lot of clusters          #
##########################################

# Population size
N <- 1000000
# Number of clusters in the population
NI <- 1000
# Number of elements per cluster
N/NI

# The variable of interest
y <- c(1:N)
# The clustering factor
cl <- kronecker(c(1:NI),rep(1,N/NI))

rho = ICC(y,cl)$ICC
rho

ss2s4m(N, mu=mean(y), sigma=sd(y), conf=0.95, rme=0.03, M=N/NI, by=10, rho)
}
\author{
Hugo Andres Gutierrez Rojas <hugogutierrez at usantotomas.edu.co>
}
\references{
Gutierrez, H. A. (2009), \emph{Estrategias de muestreo: Diseno de encuestas y estimacion de parametros}. Editorial Universidad Santo Tomas
}
\seealso{
\code{\link{ICC}}
}

