% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_Sample.R
\name{make_Sample}
\alias{make_Sample}
\title{Create a Virtual Sample.}
\usage{
make_Sample(
  book,
  depth,
  geometry = "cuboid",
  radius,
  height,
  width,
  length,
  slice = TRUE,
  force = FALSE,
  n_cores = max(1, parallel::detectCores() - 2)
)
}
\arguments{
\item{book}{\link{list} object, initially produced by \link{get_RuleBook}}

\item{depth}{\link{numeric} scalar, depth of the sample centre (m).}

\item{geometry}{\link{character} scalar, keyword defining the geometry of
the sample. One out of \code{"cuboid"} and \code{"cylinder"},
default is \code{"cuboid"}.}

\item{radius}{\link{numeric} scalar, radius of the cylinder (m).}

\item{height}{\link{numeric} scalar, height of the cuboid (m).}

\item{width}{\link{numeric} scalar, width of the cuboid (m).}

\item{length}{\link{numeric} scalar, length of the cuboid or cylinder (m).}

\item{slice}{\link{logical} scalar, option to sample in repeated slices of
10^6 grains until the required sample size is reached. Useful to avoid
memory issues for large numbers of grains per sample volume.}

\item{force}{\link{logical} scalar, option to override the default
maximum number of 10^7 grains per sample, set to avoid memory problems
of the computer.}

\item{n_cores}{\link{integer} (\emph{optional}) set the number of cores used for the parallel
processing}
}
\value{
A \link{list} object.
}
\description{
The function generates many virtual sediment grains based on the specified
sample geometry and depth, using the information from a rule book.
}
\examples{

set.seed(12234)
sample_01 <- make_Sample(
  book = get_RuleBook(), 
  depth = 1, 
  geometry = "cuboid",
  n_cores = 1,
  height = 0.001,
  width = 0.001, 
  length = 0.001)

}
\author{
Michael Dietze, GFZ Potsdam (Germany)
}
