% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/breaks.R, R/chop.R
\name{brk_width}
\alias{brk_width}
\alias{brk_evenly}
\alias{chop_width}
\alias{chop_evenly}
\title{Chop into equal-width intervals}
\usage{
brk_width(width, start)

brk_evenly(groups)

chop_width(x, width, start, ...)

chop_evenly(x, groups, ...)
}
\arguments{
\item{width}{Width of intervals.}

\item{start}{Leftpoint of first interval. By default the lowest finite \code{x}.}

\item{groups}{Integer: number of intervals to create.}

\item{x}{A numeric vector.}

\item{...}{Passed to \code{chop}.}
}
\value{
For  \verb{chop_*} functions, a factor of the same length as \code{x}.
}
\description{
\code{chop_width()} chops \code{x} into intervals of width \code{width}. \code{chop_evenly}
chops \code{x} into \code{groups} intervals of equal width.
}
\examples{
chop_width(1:10, 2)

chop_width(1:10, 2, start = 0)

chop(1:10, brk_width(2, 0))

chop_evenly(1:10, 5)

}
\seealso{
Other chopping functions: 
\code{\link{brk_mean_sd}()},
\code{\link{brk_n}()},
\code{\link{brk_quantiles}()},
\code{\link{chop}()},
\code{\link{fillet}()}
}
\concept{chopping functions}
