% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sairr_clean_observations.R
\name{saq_clean_observations}
\alias{saq_clean_observations}
\title{Function to clean and format observational data from \strong{saqgetr}'s 
\code{\link{get_saq_observations}} function.}
\usage{
saq_clean_observations(df, summary = "hour", valid_only = TRUE,
  spread = FALSE)
}
\arguments{
\item{df}{Tibble/data frame from \code{\link{get_saq_observations}}.}

\item{summary}{Summary to filter data to. Default is \code{"hour"}.}

\item{valid_only}{Should only valid observations be kept?}

\item{spread}{Should the data be "spread" where the data frame is reshaped 
so pollutants form variables/columns. This format is usually what is desired
when using \strong{openair}.}
}
\value{
Tibble.
}
\description{
Function to clean and format observational data from \strong{saqgetr}'s 
\code{\link{get_saq_observations}} function.
}
\examples{

# Load a site's data
data_hafodyrynys <- get_saq_observations(site = "gb1038a")

# Keep only valid and hourly data
data_hafodyrynys_hourly <- data_hafodyrynys \%>\% 
  saq_clean_observations(summary = "hour", valid_only = TRUE) \%>\% 
  print()

# Spread hourly data, a different table format here
data_hafodyrynys_hourly_spread <- data_hafodyrynys \%>\% 
  saq_clean_observations(summary = "hour", valid_only = TRUE, spread = TRUE) \%>\% 
  print()

}
\author{
Stuart K. Grange
}
