% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_directory_structure.R
\name{create_directory_structure}
\alias{create_directory_structure}
\title{Create a Pre-defined Directory Hierarchy on Disk}
\usage{
create_directory_structure(
  path,
  structure_path = system.file("templates", "_project_structure_en.yaml", package =
    "saros.base"),
  numbering_prefix = c("none", "max_local", "max_global"),
  numbering_inheritance = TRUE,
  word_separator = NULL,
  numbering_parent_child_separator = word_separator,
  numbering_name_separator = " ",
  case = c("asis", "sentence", "title", "lower", "upper", "snake"),
  replacement_list = c(project_initials = "SSN"),
  create = FALSE,
  count_existing_folders = FALSE
)
}
\arguments{
\item{path}{String, path to where to create the project files}

\item{structure_path}{String. Path to the YAML file that defines the folder structure. Defaults to system.file("templates", "_project_structure_en.yaml").}

\item{numbering_prefix}{String. One of c("none", "max_local", "max_global").}

\item{numbering_inheritance}{Flag. Whether to inherit numbering from parent folder.}

\item{word_separator}{String. Replace separators between words in folder names. Defaults to NULL.}

\item{numbering_parent_child_separator}{String. Defaults to word_separator.}

\item{numbering_name_separator}{String. Separator between numbering part and name.}

\item{case}{String. One of c("asis", "sentence", "lower", "upper", "title", "snake").}

\item{replacement_list}{named character vector. Each name in this vector will be replaced with its \code{"{{value}}"} in the structure_path file}

\item{create}{Boolean. Defaults to TRUE in initialize_saros_project(), FALSE in create_directory_structure().}

\item{count_existing_folders}{Boolean. Defaults to FALSE.}
}
\value{
No return value, called for side effects
}
\description{
Create a Pre-defined Directory Hierarchy on Disk
}
\examples{
create_directory_structure(path = tempdir())
}
