% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_sbo_preds.R
\name{eval_sbo_preds}
\alias{eval_sbo_preds}
\title{Evaluate Stupid Back-off next-word predictions}
\usage{
eval_sbo_preds(model, test, L = model$L)
}
\arguments{
\item{model}{a \code{sbo_preds} object.}

\item{test}{a character vector. Test corpus for model evaluation.}

\item{L}{Maximum number of predictions for each input sentence
(maximum allowed is \code{model$L})}
}
\value{
A tibble, containing the input $(N-1)$-grams, the true completions,
the predicted completions and a column indicating whether one of the
predictions were correct or not.
}
\description{
Evaluate next-word predictions based on Stupid Back-off N-gram
model on a test corpus.
}
\details{
This function allows to obtain information on Stupid Back-off model
predictions, such as next-word prediction accuracy, or the word-rank
distribution of correct prediction, by direct test against a test set corpus.

\code{eval_sbo_preds} performs the following operations:
\enumerate{
\item Sample a single $N$-gram from each sentence of test corpus.
\item Predict next words from the $(N-1)$-gram prefix.
\item Return all predictions, together with the true word completions.
}
}
\examples{
\donttest{
# Evaluating next-word predictions from a Stupid Back-off N-gram model

set.seed(840) # Set seed for reproducibility
eval <- # May take ~ 2 or 3 minutes!
        eval_sbo_preds(twitter_preds, twitter_test, L = 3)

## Compute three-word accuracies
eval \%>\% summarise(accuracy = sum(correct)/n()) # Overall accuracy
eval \%>\% # Accuracy for in-sentence predictions
        filter(true != ".") \%>\%
       summarise(accuracy = sum(correct)/n())

## Make histogram of word-rank distribution for correct predictions
if(require(ggplot2)){
        eval \%>\% ###
                filter(correct, true != ".") \%>\%
                transmute(rank = match(true, table = twitter_preds$dict)) \%>\%
                ggplot(aes(x = rank)) + geom_histogram(binwidth = 25)
}
}
}
\author{
Valerio Gherardi
}
