% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc2cp.R
\name{sc2cp}
\alias{sc2cp}
\title{Implements the geometric spatial transfer of statistics from Spanish census sections to postal code areas}
\usage{
sc2cp(x, year, data.type = "counts", all.units = FALSE, na.rm = TRUE, ...)
}
\arguments{
\item{x}{A data frame of order N x K (with K > 1) with the statistics to be spatially transferred/imputed.
The first column must contains the code of the census section to which the statistics belong to. The statistical nature
of the data columns must be of the same type. See the argument \code{data.type}.}

\item{year}{An integer number. Reference year of the census sections included in the first column of \code{x}.
Only 2001 and 2003 to 2023 are allowed.}

\item{data.type}{A character string indicating the type of data to be transferred, either \code{"counts"} (aggregate statistics)
or \code{"averages"} (mean, proportion or rate statistics). Default \code{"counts"}.}

\item{all.units}{A \code{TRUE/FALSE} logical value indicating the postal code area division to be included
in the output data frame. If \code{TRUE} all the postal code areas are included. If \code{FALSE} only
those units for which a value is imputed are included. Default, \code{FALSE}.}

\item{na.rm}{A \code{TRUE/FALSE} logical value indicating whether \code{NA} values should be stripped before
the computations proceed. Default, \code{TRUE}.}

\item{...}{Other arguments to be passed to the function. Not currently used.}
}
\value{
A list with the following components
\item{df}{ A data frame with the statistics spatially transferred to the postal code areas.}
\item{missing}{ A vector with the codes of the census sections included in \code{x} that are not available in the shp file of census sections corresponding to the \code{year.sscc.origin} division.}
}
\description{
Transfers the statistics available in a set of Spanish census sections from a given year
to the corresponding spatial set of Spanish official postal code areas.
}
\note{
The data that allows to transfer statistics among census sections
and/or postal code areas has been own elaboration by the authors using (i)
the Spanish Digital Cartography Files available in http://www.ine.es
that contain the digitalisation of the georeferenced polygons of the
census sections, according to UTM coordinates 28, 29, 30 and 31, and (ii)
the Cartography File of postal code areas developed by Goerlich (2022).

Neither The Spanish Statistical Office (Instituto Nacional de Estadística) nor
Professor Goerlich had any involvement in preparing this package. They bear no responsibility on the results derived from using this package.

Postal code areas have 2019 as reference year. It must be noted, however,
that they can be considered as almost time stationary. Spanish postal code areas are quite
stable over time.
}
\examples{
data <- structure(list(SSCC = c(0103701001, 4619401008, 4603103003),
                       pop = c(12000L, 14000L, 11000L)),
                       class = "data.frame", row.names = c(NA, -3L))
example <- sc2cp(x = data, year = 2012, data.type = "counts")
}
\references{
Goerlich, FJ (2022). Elaboracion de un mapa de codigos postales de Espana con recursos libres. Como evitar pagar a Correos 6000 euros por informacion de referencia. Working Papers Ivie n. 2022-3. Valencia: Ivie. \doi{10.12842/WPIVIE_0322}

Pavia, JM and Cantarino, I (2017a). Can dasymetric mapping significantly improve population data reallocation in a dense urban area? \emph{Geographical Analysis}, 49(2), 155-174. \doi{10.1111/gean.12112}

Pavia, JM and Cantarino, I (2017b). Dasymetric distribution of votes in a dense city. \emph{Applied Geography}, 86, 22-31. \doi{10.1016/j.apgeog.2017.06.021}

Perez, V and Pavia, JM (2024a). Improving Accuracy in Geospatial Information Transfer: A Population Density-Based Approach, in \emph{6th International Conference on Advanced Research Methods and Analytics (CARMA 2024)}, Editorial Universitat Politecnica de Valencia, pp. 326-333. \doi{10.4995/CARMA2024.2024.17796}

Perez, V and Pavia, JM  (2024b) Automating the transfer of data between census sections and postal codes areas over time. An application to Spain. \emph{Investigaciones Regionales - Journal of Regional Research}, forthcoming. \doi{10.38191/iirr-jorr.24.057}
}
\seealso{
\code{\link{sc2cp}} \code{\link{cp2sc}}
}
\author{
Jose M. Pavia, \email{pavia@uv.es}

Virgilio Perez \email{virgilio.perez@uv.es}
}
