% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Seurat_Plotting.R
\name{Cell_Highlight_Plot}
\alias{Cell_Highlight_Plot}
\title{Meta Highlight Plot}
\usage{
Cell_Highlight_Plot(
  seurat_object,
  cells_highlight,
  highlight_color = NULL,
  background_color = "lightgray",
  pt.size = NULL,
  aspect_ratio = NULL,
  figure_plot = FALSE,
  raster = NULL,
  raster.dpi = c(512, 512),
  label = FALSE,
  split.by = NULL,
  split_seurat = FALSE,
  ggplot_default_colors = FALSE,
  ...
)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{cells_highlight}{Cell names to highlight in named list.}

\item{highlight_color}{Color to highlight cells.}

\item{background_color}{non-highlighted cell colors (default is "lightgray")..}

\item{pt.size}{point size for both highlighted cluster and background.}

\item{aspect_ratio}{Control the aspect ratio (y:x axes ratio length).  Must be numeric value;
Default is NULL.}

\item{figure_plot}{logical.  Whether to remove the axes and plot with legend on left of plot denoting
axes labels.  (Default is FALSE).  Requires \code{split_seurat = TRUE}.}

\item{raster}{Convert points to raster format.  Default is NULL which will rasterize by default if
greater than 200,000 cells.}

\item{raster.dpi}{Pixel resolution for rasterized plots, passed to geom_scattermore().
Default is c(512, 512).}

\item{label}{Whether to label the highlighted meta data variable(s).  Default is FALSE.}

\item{split.by}{Variable in \verb{@meta.data} to split the plot by.}

\item{split_seurat}{logical.  Whether or not to display split plots like Seurat (shared y axis) or as
individual plots in layout.  Default is FALSE.}

\item{ggplot_default_colors}{logical.  If \code{highlight_color = NULL}, Whether or not to return plot
using default ggplot2 "hue" palette instead of default "polychrome" or "varibow" palettes.}

\item{...}{Extra parameters passed to\code{\link[Seurat]{DimPlot}}.}
}
\value{
A ggplot object
}
\description{
Create Plot with meta data variable of interest highlighted
}
\examples{
library(Seurat)

# Creating example non-overlapping vectors of cells
MS4A1 <- WhichCells(object = pbmc_small, expression = MS4A1 > 4)
GZMB <- WhichCells(object = pbmc_small, expression = GZMB > 4)

# Format as named list
cells <- list("MS4A1" = MS4A1,
              "GZMB" = GZMB)

Cell_Highlight_Plot(seurat_object = pbmc_small, cells_highlight = cells)

}
\concept{seurat_plotting}
