% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_prop_associations.R
\name{get_ctype_subc_prop_associations}
\alias{get_ctype_subc_prop_associations}
\title{Compute and plot associations between donor factor scores and donor proportions of cell subtypes}
\usage{
get_ctype_subc_prop_associations(
  container,
  ctype,
  res,
  n_col = 2,
  alt_name = NULL
)
}
\arguments{
\item{container}{environment Project container that stores sub-containers
for each cell type as well as results and plots from all analyses}

\item{ctype}{character The cell type to get results for}

\item{res}{numeric The clustering resolution to retrieve}

\item{n_col}{numeric The number of columns to organize the plots into (default=2)}

\item{alt_name}{character Alternate name for the cell type used in clustering (default=NULL)}
}
\value{
The project container with a cowplot figure of results plots in 
container$plots$ctype_prop_factor_associations.
}
\description{
Compute and plot associations between donor factor scores and donor proportions of cell subtypes
}
